/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class MockTokenizerFactory
extends TokenizerFactory {
    CharacterRunAutomaton pattern;
    boolean enableChecks;

    public void init(Map<String, String> args) {
        super.init(args);
        String patternArg = args.get("pattern");
        if (patternArg == null) {
            patternArg = "whitespace";
        }
        if ("whitespace".equalsIgnoreCase(patternArg)) {
            this.pattern = MockTokenizer.WHITESPACE;
        } else if ("keyword".equalsIgnoreCase(patternArg)) {
            this.pattern = MockTokenizer.KEYWORD;
        } else if ("simple".equalsIgnoreCase(patternArg)) {
            this.pattern = MockTokenizer.SIMPLE;
        } else {
            throw new RuntimeException("invalid pattern!");
        }
        this.enableChecks = this.getBoolean("enableChecks", true);
    }

    public Tokenizer create(Reader input) {
        MockTokenizer t = new MockTokenizer(input, this.pattern, false);
        t.setEnableChecks(this.enableChecks);
        return t;
    }
}

