/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.config.ConfigNameConstants;
import org.apache.solr.handler.dataimport.config.ConfigParseUtil;
import org.apache.solr.handler.dataimport.config.DIHConfiguration;
import org.apache.solr.handler.dataimport.config.EntityField;
import org.apache.solr.schema.SchemaField;
import org.w3c.dom.Element;

public class Entity {
    private final String name;
    private final String pk;
    private final String pkMappingFromSchema;
    private final String dataSourceName;
    private final String processorName;
    private final Entity parentEntity;
    private final boolean docRoot;
    private final boolean child;
    private final List<Entity> children;
    private final List<EntityField> fields;
    private final Map<String, Set<EntityField>> colNameVsField;
    private final Map<String, String> allAttributes;
    private final List<Map<String, String>> allFieldAttributes;
    private final DIHConfiguration config;

    public Entity(boolean docRootFound, Element element, DataImporter di, DIHConfiguration config, Entity parent) {
        SchemaField uniqueKey;
        this.parentEntity = parent;
        this.config = config;
        String modName = ConfigParseUtil.getStringAttribute(element, "name", null);
        if (modName == null) {
            throw new DataImportHandlerException(500, "Entity must have a name.");
        }
        if (modName.indexOf(".") != -1) {
            throw new DataImportHandlerException(500, "Entity name must not have period (.): '" + modName);
        }
        if (ConfigNameConstants.RESERVED_WORDS.contains(modName)) {
            throw new DataImportHandlerException(500, "Entity name : '" + modName + "' is a reserved keyword. Reserved words are: " + ConfigNameConstants.RESERVED_WORDS);
        }
        this.name = modName;
        this.pk = ConfigParseUtil.getStringAttribute(element, "pk", null);
        this.processorName = ConfigParseUtil.getStringAttribute(element, "processor", null);
        this.dataSourceName = ConfigParseUtil.getStringAttribute(element, "dataSource", null);
        String rawDocRootValue = ConfigParseUtil.getStringAttribute(element, "rootEntity", null);
        this.docRoot = !docRootFound && !"false".equals(rawDocRootValue);
        String childValue = ConfigParseUtil.getStringAttribute(element, "child", null);
        this.child = "true".equals(childValue);
        HashMap<String, String> modAttributes = ConfigParseUtil.getAllAttributes(element);
        modAttributes.put("dataSource", this.dataSourceName);
        this.allAttributes = Collections.unmodifiableMap(modAttributes);
        List<Element> n = ConfigParseUtil.getChildNodes(element, "field");
        ArrayList<EntityField> modFields = new ArrayList<EntityField>(n.size());
        HashMap modColNameVsField = new HashMap();
        ArrayList<Map<String, String>> modAllFieldAttributes = new ArrayList<Map<String, String>>();
        for (Element elem : n) {
            HashSet<EntityField> fieldSet;
            EntityField.Builder fieldBuilder = new EntityField.Builder(elem);
            if (config.getSchema() != null) {
                if (fieldBuilder.getNameOrColumn() != null && fieldBuilder.getNameOrColumn().contains("${")) {
                    fieldBuilder.dynamicName = true;
                } else {
                    SchemaField schemaField = config.getSchemaField(fieldBuilder.getNameOrColumn());
                    if (schemaField != null) {
                        fieldBuilder.name = schemaField.getName();
                        fieldBuilder.multiValued = schemaField.multiValued();
                        fieldBuilder.allAttributes.put("multiValued", Boolean.toString(schemaField.multiValued()));
                        fieldBuilder.allAttributes.put("type", schemaField.getType().getTypeName());
                        fieldBuilder.allAttributes.put("indexed", Boolean.toString(schemaField.indexed()));
                        fieldBuilder.allAttributes.put("stored", Boolean.toString(schemaField.stored()));
                        fieldBuilder.allAttributes.put("defaultValue", schemaField.getDefaultValue());
                    } else {
                        fieldBuilder.toWrite = false;
                    }
                }
            }
            if ((fieldSet = (HashSet<EntityField>)modColNameVsField.get(fieldBuilder.column)) == null) {
                fieldSet = new HashSet<EntityField>();
                modColNameVsField.put(fieldBuilder.column, fieldSet);
            }
            fieldBuilder.allAttributes.put("boost", Float.toString(fieldBuilder.boost));
            fieldBuilder.allAttributes.put("toWrite", Boolean.toString(fieldBuilder.toWrite));
            modAllFieldAttributes.add(fieldBuilder.allAttributes);
            fieldBuilder.entity = this;
            EntityField field = new EntityField(fieldBuilder);
            fieldSet.add(field);
            modFields.add(field);
        }
        HashMap modColNameVsField1 = new HashMap();
        for (Map.Entry entry : modColNameVsField.entrySet()) {
            if (((Set)entry.getValue()).size() <= 0) continue;
            modColNameVsField1.put(entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.colNameVsField = Collections.unmodifiableMap(modColNameVsField1);
        this.fields = Collections.unmodifiableList(modFields);
        this.allFieldAttributes = Collections.unmodifiableList(modAllFieldAttributes);
        String modPkMappingFromSchema = null;
        if (config.getSchema() != null && (uniqueKey = config.getSchema().getUniqueKeyField()) != null) {
            modPkMappingFromSchema = uniqueKey.getName();
            for (EntityField field : this.fields) {
                if (!field.getName().equals(modPkMappingFromSchema)) continue;
                modPkMappingFromSchema = field.getColumn();
                break;
            }
        }
        this.pkMappingFromSchema = modPkMappingFromSchema;
        n = ConfigParseUtil.getChildNodes(element, "entity");
        ArrayList<Entity> modEntities = new ArrayList<Entity>();
        for (Element elem : n) {
            modEntities.add(new Entity(docRootFound || this.docRoot, elem, di, config, this));
        }
        this.children = Collections.unmodifiableList(modEntities);
    }

    public String getPk() {
        return this.pk == null ? this.pkMappingFromSchema : this.pk;
    }

    public String getSchemaPk() {
        return this.pkMappingFromSchema != null ? this.pkMappingFromSchema : this.pk;
    }

    public String getName() {
        return this.name;
    }

    public String getPkMappingFromSchema() {
        return this.pkMappingFromSchema;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public Entity getParentEntity() {
        return this.parentEntity;
    }

    public boolean isDocRoot() {
        return this.docRoot;
    }

    public List<Entity> getChildren() {
        return this.children;
    }

    public List<EntityField> getFields() {
        return this.fields;
    }

    public Map<String, Set<EntityField>> getColNameVsField() {
        return this.colNameVsField;
    }

    public Map<String, String> getAllAttributes() {
        return this.allAttributes;
    }

    public List<Map<String, String>> getAllFieldsList() {
        return this.allFieldAttributes;
    }

    public boolean isChild() {
        return this.child;
    }
}

