/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexTransformer
extends Transformer {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private HashMap<String, Pattern> PATTERN_CACHE = new HashMap();
    public static final String REGEX = "regex";
    public static final String REPLACE_WITH = "replaceWith";
    public static final String SPLIT_BY = "splitBy";
    public static final String SRC_COL_NAME = "sourceColName";
    public static final String GROUP_NAMES = "groupNames";

    @Override
    public Map<String, Object> transformRow(Map<String, Object> row, Context ctx) {
        List<Map<String, String>> fields = ctx.getAllEntityFields();
        for (Map<String, String> field : fields) {
            Object tmpVal;
            String col = field.get("column");
            String reStr = ctx.replaceTokens(field.get(REGEX));
            String splitBy = ctx.replaceTokens(field.get(SPLIT_BY));
            String replaceWith = ctx.replaceTokens(field.get(REPLACE_WITH));
            String groupNames = ctx.replaceTokens(field.get(GROUP_NAMES));
            if (reStr == null && splitBy == null) continue;
            String srcColName = field.get(SRC_COL_NAME);
            if (srcColName == null) {
                srcColName = col;
            }
            if ((tmpVal = row.get(srcColName)) == null) continue;
            if (tmpVal instanceof List) {
                List inputs = (List)tmpVal;
                ArrayList<Object> results = new ArrayList<Object>();
                HashMap otherVars = null;
                for (String input : inputs) {
                    Object o = this.process(col, reStr, splitBy, replaceWith, input, groupNames);
                    if (o == null) continue;
                    if (o instanceof Map) {
                        Map map = (Map)o;
                        Iterator i$ = map.entrySet().iterator();
                        while (i$.hasNext()) {
                            Map.Entry e;
                            Map.Entry entry = e = i$.next();
                            List<Object> l = results;
                            if (!col.equals(entry.getKey())) {
                                if (otherVars == null) {
                                    otherVars = new HashMap();
                                }
                                if ((l = (List)otherVars.get(entry.getKey())) == null) {
                                    l = new ArrayList();
                                    otherVars.put(entry.getKey(), (ArrayList<Object>)l);
                                }
                            }
                            if (entry.getValue() instanceof Collection) {
                                l.addAll((Collection)entry.getValue());
                                continue;
                            }
                            l.add(entry.getValue());
                        }
                        continue;
                    }
                    if (o instanceof Collection) {
                        results.addAll((Collection)o);
                        continue;
                    }
                    results.add(o);
                }
                row.put(col, results);
                if (otherVars == null) continue;
                row.putAll(otherVars);
                continue;
            }
            String value = tmpVal.toString();
            Object o = this.process(col, reStr, splitBy, replaceWith, value, groupNames);
            if (o == null) continue;
            if (o instanceof Map) {
                row.putAll((Map)o);
                continue;
            }
            row.put(col, o);
        }
        return row;
    }

    private Object process(String col, String reStr, String splitBy, String replaceWith, String value, String groupNames) {
        if (splitBy != null) {
            return this.readBySplit(splitBy, value);
        }
        if (replaceWith != null) {
            Pattern p = this.getPattern(reStr);
            Matcher m = p.matcher(value);
            return m.find() ? m.replaceAll(replaceWith) : value;
        }
        return this.readfromRegExp(reStr, value, col, groupNames);
    }

    private List<String> readBySplit(String splitBy, String value) {
        String[] vals = value.split(splitBy);
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(Arrays.asList(vals));
        return l;
    }

    private Object readfromRegExp(String reStr, String value, String columnName, String gNames) {
        Pattern regexp;
        Matcher m;
        String[] groupNames = null;
        if (gNames != null && gNames.trim().length() > 0) {
            groupNames = gNames.split(",");
        }
        if ((m = (regexp = this.getPattern(reStr)).matcher(value)).find() && m.groupCount() > 0) {
            if (m.groupCount() > 1) {
                ArrayList<String> l = null;
                HashMap<String, String> map = null;
                if (groupNames == null) {
                    l = new ArrayList<String>();
                } else {
                    map = new HashMap<String, String>();
                }
                for (int i = 1; i <= m.groupCount(); ++i) {
                    try {
                        String nameOfGroup;
                        if (l != null) {
                            l.add(m.group(i));
                            continue;
                        }
                        if (map == null || i > groupNames.length || (nameOfGroup = groupNames[i - 1]) == null || nameOfGroup.trim().length() <= 0) continue;
                        map.put(nameOfGroup, m.group(i));
                        continue;
                    }
                    catch (Exception e) {
                        LOG.warn("Parsing failed for field : " + columnName, (Throwable)e);
                    }
                }
                return l == null ? map : l;
            }
            return m.group(1);
        }
        return null;
    }

    private Pattern getPattern(String reStr) {
        Pattern result = this.PATTERN_CACHE.get(reStr);
        if (result == null) {
            result = Pattern.compile(reStr);
            this.PATTERN_CACHE.put(reStr, result);
        }
        return result;
    }
}

