/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DIHCacheSupport;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.Zipper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityProcessorBase
extends EntityProcessor {
    private static final Logger log = LoggerFactory.getLogger(EntityProcessorBase.class);
    protected boolean isFirstInit = true;
    protected String entityName;
    protected Context context;
    protected Iterator<Map<String, Object>> rowIterator;
    protected String query;
    protected String onError = "abort";
    protected DIHCacheSupport cacheSupport = null;
    private Zipper zipper;
    public static final String TRANSFORMER = "transformer";
    public static final String TRANSFORM_ROW = "transformRow";
    public static final String ON_ERROR = "onError";
    public static final String ABORT = "abort";
    public static final String CONTINUE = "continue";
    public static final String SKIP = "skip";

    @Override
    public void init(Context context) {
        this.context = context;
        if (this.isFirstInit) {
            this.firstInit(context);
        }
        if (this.zipper != null) {
            this.zipper.onNewParent(context);
        } else if (this.cacheSupport != null) {
            this.cacheSupport.initNewParent(context);
        }
    }

    protected void firstInit(Context context) {
        this.entityName = context.getEntityAttribute("name");
        String s = context.getEntityAttribute(ON_ERROR);
        if (s != null) {
            this.onError = s;
        }
        this.zipper = Zipper.createOrNull(context);
        if (this.zipper == null) {
            this.initCache(context);
        }
        this.isFirstInit = false;
    }

    protected void initCache(Context context) {
        String cacheImplName = context.getResolvedEntityAttribute("cacheImpl");
        if (cacheImplName != null) {
            this.cacheSupport = new DIHCacheSupport(context, cacheImplName);
        }
    }

    @Override
    public Map<String, Object> nextModifiedRowKey() {
        return null;
    }

    @Override
    public Map<String, Object> nextDeletedRowKey() {
        return null;
    }

    @Override
    public Map<String, Object> nextModifiedParentRowKey() {
        return null;
    }

    @Override
    public Map<String, Object> nextRow() {
        return null;
    }

    protected Map<String, Object> getNext() {
        if (this.zipper != null) {
            return this.zipper.supplyNextChild(this.rowIterator);
        }
        if (this.cacheSupport == null) {
            try {
                if (this.rowIterator == null) {
                    return null;
                }
                if (this.rowIterator.hasNext()) {
                    return this.rowIterator.next();
                }
                this.query = null;
                this.rowIterator = null;
                return null;
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("getNext() failed for query '" + this.query + "'"), (Throwable)e);
                this.query = null;
                this.rowIterator = null;
                DataImportHandlerException.wrapAndThrow(400, e);
                return null;
            }
        }
        return this.cacheSupport.getCacheData(this.context, this.query, this.rowIterator);
    }

    @Override
    public void destroy() {
        this.query = null;
        if (this.cacheSupport != null) {
            this.cacheSupport.destroyAll();
        }
        this.cacheSupport = null;
    }
}

