/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering.carrot2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.clustering.carrot2.CarrotParams;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrResourceLocator
implements IResourceLocator {
    private final SolrResourceLoader resourceLoader;
    private final String carrot2ResourcesDir;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public SolrResourceLocator(SolrCore core, SolrParams initParams) {
        this.resourceLoader = core.getResourceLoader();
        String lexicalResourcesDir = initParams.get(CarrotParams.LEXICAL_RESOURCES_DIR);
        String resourcesDir = initParams.get(CarrotParams.RESOURCES_DIR);
        this.carrot2ResourcesDir = SolrResourceLocator.firstNonNull(resourcesDir, lexicalResourcesDir, "clustering/carrot2");
    }

    public static <T> T firstNonNull(T ... args) {
        for (T t : args) {
            if (t == null) continue;
            return t;
        }
        throw new NullPointerException("At least one element has to be non-null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResource[] getAll(String resource) {
        byte[] asBytes;
        final String resourceName = this.carrot2ResourcesDir + "/" + resource;
        log.debug("Looking for Solr resource: " + resourceName);
        InputStream resourceStream = null;
        try {
            resourceStream = this.resourceLoader.openResource(resourceName);
            asBytes = IOUtils.toByteArray((InputStream)resourceStream);
        }
        catch (IOException e) {
            log.debug("Resource not found in Solr's config: " + resourceName + ". Using the default " + resource + " from Carrot JAR.");
            IResource[] iResourceArray = new IResource[]{};
            return iResourceArray;
        }
        finally {
            if (resourceStream != null) {
                try {
                    resourceStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        log.info("Loaded Solr resource: " + resourceName);
        IResource foundResource = new IResource(){

            public InputStream open() {
                return new ByteArrayInputStream(asBytes);
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(Object obj) {
                return super.equals(obj);
            }

            public String toString() {
                return "Solr config resource: " + resourceName;
            }
        };
        return new IResource[]{foundResource};
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        String configDir = "";
        try {
            configDir = "configDir=" + new File(this.resourceLoader.getConfigDir()).getAbsolutePath() + ", ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "SolrResourceLocator, " + configDir + "Carrot2 relative lexicalResourcesDir=" + this.carrot2ResourcesDir;
    }
}

