/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering.carrot2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.clustering.SearchClusteringEngine;
import org.apache.solr.handler.clustering.carrot2.CarrotParams;
import org.apache.solr.handler.clustering.carrot2.LuceneCarrot2StemmerFactory;
import org.apache.solr.handler.clustering.carrot2.LuceneCarrot2TokenizerFactory;
import org.apache.solr.handler.clustering.carrot2.SolrStopwordsCarrot2LexicalDataFactory;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;
import org.carrot2.core.Cluster;
import org.carrot2.core.Controller;
import org.carrot2.core.ControllerFactory;
import org.carrot2.core.Document;
import org.carrot2.core.IClusteringAlgorithm;
import org.carrot2.text.linguistic.DefaultLexicalDataFactoryDescriptor;
import org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipelineDescriptor;
import org.carrot2.util.resource.ClassLoaderLocator;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;
import org.carrot2.util.resource.ResourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarrotClusteringEngine
extends SearchClusteringEngine {
    private static transient Logger log = LoggerFactory.getLogger(CarrotClusteringEngine.class);
    private static final String CARROT_RESOURCES_PREFIX = "clustering/carrot2";
    private static final String SOLR_DOCUMENT_ID = "solrId";
    private String idFieldName;
    private Controller controller = ControllerFactory.createPooling();
    private Class<? extends IClusteringAlgorithm> clusteringAlgorithmClass;

    @Override
    @Deprecated
    public Object cluster(Query query, DocList docList, SolrQueryRequest sreq) {
        SolrIndexSearcher searcher = sreq.getSearcher();
        try {
            HashMap<SolrDocument, Integer> docIds = new HashMap<SolrDocument, Integer>(docList.size());
            SolrDocumentList solrDocList = SolrPluginUtils.docListToSolrDocumentList((DocList)docList, (SolrIndexSearcher)searcher, this.getFieldsToLoad(sreq), docIds);
            return this.cluster(query, solrDocList, docIds, sreq);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public Object cluster(Query query, SolrDocumentList solrDocList, Map<SolrDocument, Integer> docIds, SolrQueryRequest sreq) {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            List<Document> documents = this.getDocuments(solrDocList, docIds, query, sreq);
            attributes.put("documents", documents);
            attributes.put("query", query.toString());
            attributes.put("solrFieldNames", this.getFieldsForClustering(sreq));
            this.extractCarrotAttributes(sreq.getParams(), attributes);
            return this.clustersToNamedList(this.controller.process(attributes, new Class[]{this.clusteringAlgorithmClass}).getClusters(), sreq.getParams());
        }
        catch (Exception e) {
            log.error("Carrot2 clustering failed", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Carrot2 clustering failed", (Throwable)e);
        }
    }

    @Override
    public String init(NamedList config, final SolrCore core) {
        String result = super.init(config, core);
        final SolrParams initParams = SolrParams.toSolrParams((NamedList)config);
        HashMap<String, Object> initAttributes = new HashMap<String, Object>();
        this.extractCarrotAttributes(initParams, initAttributes);
        BasicPreprocessingPipelineDescriptor.attributeBuilder(initAttributes).stemmerFactory(LuceneCarrot2StemmerFactory.class).tokenizerFactory(LuceneCarrot2TokenizerFactory.class).lexicalDataFactory(SolrStopwordsCarrot2LexicalDataFactory.class);
        initAttributes.put("solrIndexSchema", core.getSchema());
        DefaultLexicalDataFactoryDescriptor.attributeBuilder(initAttributes).resourceLookup(new ResourceLookup(new IResourceLocator[]{new IResourceLocator(){

            public IResource[] getAll(String resource) {
                SolrResourceLoader resourceLoader = core.getResourceLoader();
                String carrot2ResourcesDir = resourceLoader.getConfigDir() + initParams.get("carrot.lexicalResourcesDir", CarrotClusteringEngine.CARROT_RESOURCES_PREFIX);
                try {
                    log.debug("Looking for " + resource + " in " + carrot2ResourcesDir);
                    final InputStream resourceStream = resourceLoader.openResource(carrot2ResourcesDir + "/" + resource);
                    log.info(resource + " loaded from " + carrot2ResourcesDir);
                    IResource foundResource = new IResource(){

                        public InputStream open() throws IOException {
                            return resourceStream;
                        }
                    };
                    return new IResource[]{foundResource};
                }
                catch (RuntimeException e) {
                    log.debug(resource + " not found in " + carrot2ResourcesDir + ". Using the default " + resource + " from Carrot JAR.");
                    return new IResource[0];
                }
            }
        }, new ClassLoaderLocator(core.getResourceLoader().getClassLoader())}));
        this.controller.init(initAttributes);
        this.idFieldName = core.getSchema().getUniqueKeyField().getName();
        String carrotAlgorithmClassName = initParams.get("carrot.algorithm");
        Class algorithmClass = core.getResourceLoader().findClass(carrotAlgorithmClassName, new String[0]);
        if (!IClusteringAlgorithm.class.isAssignableFrom(algorithmClass)) {
            throw new IllegalArgumentException("Class provided as carrot.algorithm must implement " + IClusteringAlgorithm.class.getName());
        }
        this.clusteringAlgorithmClass = algorithmClass;
        return result;
    }

    @Override
    protected Set<String> getFieldsToLoad(SolrQueryRequest sreq) {
        SolrParams solrParams = sreq.getParams();
        HashSet fields = Sets.newHashSet(this.getFieldsForClustering(sreq));
        fields.add(this.idFieldName);
        fields.add(solrParams.get("carrot.url", "url"));
        return fields;
    }

    private Set<String> getFieldsForClustering(SolrQueryRequest sreq) {
        String titleField;
        SolrParams solrParams = sreq.getParams();
        String snippetField = solrParams.get("carrot.snippet", titleField = solrParams.get("carrot.title", "title"));
        if (StringUtils.isBlank((String)snippetField)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "carrot.snippet must not be blank.");
        }
        return Sets.newHashSet((Object[])new String[]{titleField, snippetField});
    }

    private List<Document> getDocuments(SolrDocumentList solrDocList, Map<SolrDocument, Integer> docIds, Query query, final SolrQueryRequest sreq) throws IOException {
        SolrHighlighter highlighter = null;
        SolrParams solrParams = sreq.getParams();
        SolrCore core = sreq.getCore();
        String urlField = solrParams.get("carrot.url", "url");
        String titleField = solrParams.get("carrot.title", "title");
        String snippetField = solrParams.get("carrot.snippet", titleField);
        boolean produceSummary = solrParams.getBool("carrot.produceSummary", false);
        LocalSolrQueryRequest req = null;
        String[] snippetFieldAry = null;
        if (produceSummary) {
            highlighter = core.getHighlighter();
            if (highlighter != null) {
                HashMap args = Maps.newHashMap();
                snippetFieldAry = new String[]{snippetField};
                args.put("hl.fl", snippetFieldAry);
                args.put("hl", "true");
                args.put("hl.simple.pre", "");
                args.put("hl.simple.post", "");
                args.put("hl.fragsize", solrParams.getInt("carrot.fragzise", solrParams.getInt("hl.fragsize", 100)));
                req = new LocalSolrQueryRequest(core, query.toString(), "", 0, 1, args){

                    public SolrIndexSearcher getSearcher() {
                        return sreq.getSearcher();
                    }
                };
            } else {
                log.warn("No highlighter configured, cannot produce summary");
                produceSummary = false;
            }
        }
        Iterator docsIter = solrDocList.iterator();
        ArrayList<Document> result = new ArrayList<Document>(solrDocList.size());
        float[] scores = new float[]{1.0f};
        int[] docsHolder = new int[1];
        Query theQuery = query;
        while (docsIter.hasNext()) {
            SolrDocument sdoc = (SolrDocument)docsIter.next();
            String snippet = this.getValue(sdoc, snippetField);
            if (produceSummary && docIds != null) {
                NamedList tmp;
                String[] highlt;
                docsHolder[0] = docIds.get(sdoc);
                DocSlice docAsList = new DocSlice(0, 1, docsHolder, scores, 1, 1.0f);
                NamedList highlights = highlighter.doHighlighting((DocList)docAsList, theQuery, (SolrQueryRequest)req, snippetFieldAry);
                if (highlights != null && highlights.size() == 1 && (highlt = (String[])(tmp = (NamedList)highlights.getVal(0)).get(snippetField)) != null && highlt.length == 1) {
                    snippet = highlt[0];
                }
            }
            Document carrotDocument = new Document(this.getValue(sdoc, titleField), snippet, (String)sdoc.getFieldValue(urlField));
            carrotDocument.setField(SOLR_DOCUMENT_ID, sdoc.getFieldValue(this.idFieldName));
            result.add(carrotDocument);
        }
        return result;
    }

    @Deprecated
    protected String getValue(org.apache.lucene.document.Document doc, String field) {
        StringBuilder result = new StringBuilder();
        String[] vals = doc.getValues(field);
        for (int i = 0; i < vals.length; ++i) {
            result.append(vals[i]).append(" . ");
        }
        return result.toString().trim();
    }

    protected String getValue(SolrDocument sdoc, String field) {
        StringBuilder result = new StringBuilder();
        Collection vals = sdoc.getFieldValues(field);
        if (vals == null) {
            return "";
        }
        Iterator ite = vals.iterator();
        while (ite.hasNext()) {
            result.append((String)ite.next()).append(" . ");
        }
        return result.toString().trim();
    }

    private List<NamedList<Object>> clustersToNamedList(List<Cluster> carrotClusters, SolrParams solrParams) {
        ArrayList result = Lists.newArrayList();
        this.clustersToNamedList(carrotClusters, result, solrParams.getBool("carrot.outputSubClusters", true), solrParams.getInt("carrot.numDescriptions", Integer.MAX_VALUE));
        return result;
    }

    private void clustersToNamedList(List<Cluster> outputClusters, List<NamedList<Object>> parent, boolean outputSubClusters, int maxLabels) {
        for (Cluster outCluster : outputClusters) {
            SimpleOrderedMap cluster = new SimpleOrderedMap();
            parent.add((NamedList<Object>)cluster);
            List labels = outCluster.getPhrases();
            if (labels.size() > maxLabels) {
                labels = labels.subList(0, maxLabels);
            }
            cluster.add("labels", (Object)labels);
            Double score = outCluster.getScore();
            if (score != null) {
                cluster.add("score", (Object)score);
            }
            if (outCluster.isOtherTopics()) {
                cluster.add("other-topics", (Object)outCluster.isOtherTopics());
            }
            List docs = outputSubClusters ? outCluster.getDocuments() : outCluster.getAllDocuments();
            ArrayList docList = Lists.newArrayList();
            cluster.add("docs", (Object)docList);
            for (Document doc : docs) {
                docList.add(doc.getField(SOLR_DOCUMENT_ID));
            }
            if (!outputSubClusters || outCluster.getSubclusters().isEmpty()) continue;
            ArrayList subclusters = Lists.newArrayList();
            cluster.add("clusters", (Object)subclusters);
            this.clustersToNamedList(outCluster.getSubclusters(), subclusters, outputSubClusters, maxLabels);
        }
    }

    private void extractCarrotAttributes(SolrParams solrParams, Map<String, Object> attributes) {
        Iterator paramNames = solrParams.getParameterNamesIterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            if (CarrotParams.CARROT_PARAM_NAMES.contains(paramName)) continue;
            attributes.put(paramName, solrParams.get(paramName));
        }
    }
}

