/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.facet;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.analytics.facet.AbstractSolrQueryFacet;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.Filter;
import org.apache.solr.search.QParser;

public class QueryFacet
extends AbstractSolrQueryFacet {
    private final Map<String, String> queries;

    public QueryFacet(String name, Map<String, String> queries) {
        super(name);
        this.queries = queries;
    }

    @Override
    public void createFacetValueExecuters(Filter filter, SolrQueryRequest queryRequest, Consumer<AbstractSolrQueryFacet.FacetValueQueryExecuter> consumer) {
        this.queries.forEach((queryName, query) -> {
            Query q;
            try {
                q = QParser.getParser((String)query, (SolrQueryRequest)queryRequest).getQuery();
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid query '" + query + "' in query facet '" + this.getName() + "'", (Throwable)e);
            }
            BooleanQuery queryQuery = new BooleanQuery.Builder().add(q, BooleanClause.Occur.MUST).add((Query)filter, BooleanClause.Occur.FILTER).build();
            ReductionCollectionManager.ReductionDataCollection dataCol = this.collectionManager.newDataCollection();
            this.reductionData.put(queryName, dataCol);
            consumer.accept(new AbstractSolrQueryFacet.FacetValueQueryExecuter(dataCol, (Query)queryQuery));
        });
    }
}

