/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.CountCollector;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.common.SolrException;

public class MissingFunction
extends LongValue.AbstractLongValue
implements ReductionFunction {
    private CountCollector.ExpressionCountCollector collector;
    public static final String name = "missing";
    private final String exprStr;
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The missing function requires 1 paramater, " + params.length + " found.");
        }
        return new MissingFunction(params[0]);
    };

    public MissingFunction(AnalyticsValueStream param) {
        this.collector = new CountCollector.ExpressionCountCollector(param);
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    @Override
    public long getLong() {
        return this.collector.missing();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (CountCollector.ExpressionCountCollector)sync.apply(this.collector);
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

