/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value.constant;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.constant.ConstantBooleanValue;
import org.apache.solr.analytics.value.constant.ConstantDateValue;
import org.apache.solr.analytics.value.constant.ConstantDoubleValue;
import org.apache.solr.analytics.value.constant.ConstantFloatValue;
import org.apache.solr.analytics.value.constant.ConstantIntValue;
import org.apache.solr.analytics.value.constant.ConstantLongValue;
import org.apache.solr.analytics.value.constant.ConstantStringValue;
import org.apache.solr.common.SolrException;

public abstract class ConstantValue {
    private static final Pattern truePattern = Pattern.compile("^true|t$", 2);
    private static final Pattern falsePattern = Pattern.compile("^false|f$", 2);
    private static final SimpleDateFormat dateParserBase = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
    private static final SimpleDateFormat dateParser1 = new SimpleDateFormat("yyyy-MM-ddZ", Locale.ROOT);
    private static final SimpleDateFormat dateParser2 = new SimpleDateFormat("yyyy-MM-ddXXX", Locale.ROOT);
    private static final SimpleDateFormat dateParser3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ROOT);
    private static final SimpleDateFormat dateParser4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX", Locale.ROOT);
    private static final SimpleDateFormat dateParser5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ROOT);
    private static final SimpleDateFormat dateParser6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ROOT);
    public static final ExpressionFactory.ConstantFunction creatorFunction = param -> {
        if ((param = param.trim()).charAt(0) == '\"' && param.charAt(param.length() - 1) == '\"' || param.charAt(0) == '\'' && param.charAt(param.length() - 1) == '\'') {
            return new ConstantStringValue(param.substring(1, param.length() - 1));
        }
        Matcher m = truePattern.matcher(param);
        if (m.matches()) {
            return new ConstantBooleanValue(true);
        }
        m = falsePattern.matcher(param);
        if (m.matches()) {
            return new ConstantBooleanValue(false);
        }
        try {
            ConstantValue value = new ConstantDoubleValue(Double.parseDouble(param));
            try {
                value = new ConstantLongValue(Long.parseLong(param));
                value = new ConstantIntValue(Integer.parseInt(param));
            }
            catch (NumberFormatException e) {
                value = new ConstantFloatValue(Float.parseFloat(param));
            }
            return value;
        }
        catch (NumberFormatException value) {
            try {
                ConstantDateValue value2 = new ConstantDateValue(dateParserBase.parse(param).getTime());
                try {
                    return new ConstantDateValue(dateParser1.parse(param).getTime());
                }
                catch (Exception exception) {
                    try {
                        return new ConstantDateValue(dateParser2.parse(param).getTime());
                    }
                    catch (Exception exception2) {
                        try {
                            return new ConstantDateValue(dateParser3.parse(param).getTime());
                        }
                        catch (Exception exception3) {
                            try {
                                return new ConstantDateValue(dateParser4.parse(param).getTime());
                            }
                            catch (Exception exception4) {
                                try {
                                    return new ConstantDateValue(dateParser5.parse(param).getTime());
                                }
                                catch (Exception exception5) {
                                    try {
                                        return new ConstantDateValue(dateParser6.parse(param).getTime());
                                    }
                                    catch (Exception exception6) {
                                        return value2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The parameter " + param + " could not be cast to any constant.");
            }
        }
    };

    static String createExpressionString(AnalyticsValueStream func, Object param) {
        return String.format(Locale.ROOT, "%s(%s)", func.getName(), param.toString());
    }
}

