/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.StringValueStream;

public interface FloatValueStream
extends AnalyticsValueStream {
    public void streamFloats(FloatConsumer var1);

    public static abstract class AbstractFloatValueStream
    implements CastingFloatValueStream {
        @Override
        public void streamDoubles(DoubleConsumer cons) {
            this.streamFloats(val -> cons.accept(val));
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            this.streamFloats(val -> cons.accept(Float.toString(val)));
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            this.streamFloats(val -> cons.accept(Float.valueOf(val)));
        }
    }

    public static interface CastingFloatValueStream
    extends FloatValueStream,
    DoubleValueStream,
    StringValueStream {
    }
}

