/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value;

import java.time.Instant;
import java.util.Date;
import java.util.function.Consumer;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValueStream;

public interface DateValueStream
extends LongValueStream {
    public void streamDates(Consumer<Date> var1);

    public static abstract class AbstractDateValueStream
    implements CastingDateValueStream {
        @Override
        public void streamDates(Consumer<Date> cons) {
            this.streamLongs(val -> cons.accept(new Date(val)));
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            this.streamLongs(val -> cons.accept(Instant.ofEpochMilli(val).toString()));
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            this.streamLongs(val -> cons.accept(new Date(val)));
        }
    }

    public static interface CastingDateValueStream
    extends DateValueStream,
    LongValueStream,
    StringValueStream {
    }
}

