/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.solr.analytics.AnalyticsRequestParser;

public interface OldAnalyticsParams {
    public static final String OLD_ANALYTICS = "olap";
    public static final String OLD_PREFIX = "o|olap";
    public static final String OLD_EXPRESSION = "s|stat|statistic";
    public static final String FIELD_FACET = "ff|fieldfacet";
    public static final String VALUE_FACET = "vf|valuefacet";
    public static final String LIMIT = "l|limit";
    public static final String OFFSET = "off|offset";
    public static final String SHOW_MISSING = "sm|showmissing";
    public static final String SORT_EXPRESSION = "se|sortexpr|sortexpression";
    public static final String OLAP_SORT_EXPRESSION = "ss|sortstat|sortstatistic";
    public static final String SORT_DIRECTION = "sd|sortdirection";
    public static final String RANGE_FACET = "rf|rangefacet";
    public static final String START = "st|start";
    public static final String END = "e|end";
    public static final String GAP = "g|gap";
    public static final String HARDEND = "he|hardend";
    public static final String INCLUDE_BOUNDARY = "ib|includebound";
    public static final String OTHER_RANGE = "or|otherrange";
    public static final String QUERY_FACET = "qf|queryfacet";
    public static final String QUERY = "q|query";
    public static final boolean DEFAULT_ABBREVIATE_PREFIX = true;

    public static class OldQueryFacet {
        public String name;
        public String[] queries;
    }

    public static class RangeFacetParamParser {
        public static String regexParamList = "st|start|e|end|g|gap|he|hardend|ib|includebound|or|otherrange";
        private static Predicate<String> isStart = Pattern.compile("^st|start$", 2).asPredicate();
        private static Predicate<String> isEnd = Pattern.compile("^e|end$", 2).asPredicate();
        private static Predicate<String> isGap = Pattern.compile("^g|gap$", 2).asPredicate();
        private static Predicate<String> isHardEnd = Pattern.compile("^he|hardend$", 2).asPredicate();
        private static Predicate<String> isTrue = Pattern.compile("^t|true$", 2).asPredicate();
        private static Predicate<String> isFalse = Pattern.compile("^f|false$", 2).asPredicate();
        private static Predicate<String> isInclude = Pattern.compile("^ib|includebound$", 2).asPredicate();
        private static Predicate<String> isOther = Pattern.compile("^or|otherrange$", 2).asPredicate();

        public static void applyParam(AnalyticsRequestParser.AnalyticsRangeFacetRequest facet, String param, String[] values) {
            if (isStart.test(param)) {
                facet.start = values[0];
            } else if (isEnd.test(param)) {
                facet.end = values[0];
            } else if (isGap.test(param)) {
                facet.gaps = Arrays.asList(values[0].split(","));
            } else if (isHardEnd.test(param)) {
                if (isTrue.test(values[0])) {
                    facet.hardend = true;
                } else if (isFalse.test(values[0])) {
                    facet.hardend = false;
                }
            } else if (isInclude.test(param)) {
                facet.include = Arrays.asList(values);
            } else if (isOther.test(param)) {
                facet.others = Arrays.asList(values);
            }
        }
    }

    public static class OldRangeFacet {
        public String field;
        public String start;
        public String end;
        public String gaps;
        public String hardend;
        public String[] include;
        public String[] others;
    }

    public static class FieldFacetParamParser {
        public static String regexParamList = "l|limit|off|offset|sm|showmissing|ss|sortstat|sortstatistic|sd|sortdirection";
        private static Predicate<String> isLimit = Pattern.compile("^l|limit$", 2).asPredicate();
        private static Predicate<String> isOffset = Pattern.compile("^off|offset$", 2).asPredicate();
        private static Predicate<String> isShowMissing = Pattern.compile("^sm|showmissing$", 2).asPredicate();
        private static Predicate<String> isSortExpr = Pattern.compile("^ss|sortstat|sortstatistic$", 2).asPredicate();
        private static Predicate<String> isSortDir = Pattern.compile("^sd|sortdirection$", 2).asPredicate();

        public static void applyParam(AnalyticsRequestParser.AnalyticsValueFacetRequest facet, String param, String value) {
            if (isLimit.test(param)) {
                FieldFacetParamParser.getSort((AnalyticsRequestParser.AnalyticsValueFacetRequest)facet).limit = Integer.parseInt(value);
            } else if (isOffset.test(param)) {
                FieldFacetParamParser.getSort((AnalyticsRequestParser.AnalyticsValueFacetRequest)facet).offset = Integer.parseInt(value);
            } else if (isShowMissing.test(param)) {
                facet.expression = "fillmissing(" + facet.expression + ",\"(MISSING)\")";
            } else if (isSortExpr.test(param)) {
                AnalyticsRequestParser.AnalyticsExpressionSortRequest criterion;
                AnalyticsRequestParser.AnalyticsSortRequest sort = FieldFacetParamParser.getSort(facet);
                if (sort.criteria.size() == 0) {
                    criterion = new AnalyticsRequestParser.AnalyticsExpressionSortRequest();
                    sort.criteria.add(criterion);
                } else {
                    criterion = (AnalyticsRequestParser.AnalyticsExpressionSortRequest)sort.criteria.get(0);
                }
                criterion.expression = value;
            } else if (isSortDir.test(param)) {
                AnalyticsRequestParser.AnalyticsExpressionSortRequest criterion;
                AnalyticsRequestParser.AnalyticsSortRequest sort = FieldFacetParamParser.getSort(facet);
                if (sort.criteria.size() == 0) {
                    criterion = new AnalyticsRequestParser.AnalyticsExpressionSortRequest();
                    sort.criteria.add(criterion);
                } else {
                    criterion = (AnalyticsRequestParser.AnalyticsExpressionSortRequest)sort.criteria.get(0);
                }
                criterion.direction = value;
            }
        }

        public static AnalyticsRequestParser.AnalyticsSortRequest getSort(AnalyticsRequestParser.AnalyticsValueFacetRequest facet) {
            if (facet.sort == null) {
                facet.sort = new AnalyticsRequestParser.AnalyticsSortRequest();
                facet.sort.criteria = new ArrayList<AnalyticsRequestParser.AnalyticsSortCriteriaRequest>();
            }
            return facet.sort;
        }
    }

    public static class OldFieldFacet {
        public String field;
        public String showMissing;
        public String limit;
        public String offset;
        public String sortExpr;
        public String sortDir;
    }

    public static class OldRequest {
        public String name;
        public Map<String, String> expressions = new HashMap<String, String>();
        public Map<String, OldFieldFacet> fieldFacets = new HashMap<String, OldFieldFacet>();
        public Map<String, OldRangeFacet> rangeFacets = new HashMap<String, OldRangeFacet>();
        public Map<String, OldQueryFacet> queryFacets = new HashMap<String, OldQueryFacet>();
    }
}

