/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.common.SolrException;

class StringToDateParseFunction
extends DateValue.AbstractDateValue {
    private final StringValue param;
    public static final String name = "date";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    public static final DateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS", Locale.ROOT);
    private boolean exists = false;

    public StringToDateParseFunction(StringValue param) throws SolrException {
        this.param = param;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
    }

    @Override
    public long getLong() {
        long value = 0L;
        try {
            value = formatter.parse(this.param.toString()).getTime();
            this.exists = this.param.exists();
        }
        catch (ParseException e) {
            this.exists = false;
        }
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

