/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

class StringStreamReplaceFunction
extends StringValueStream.AbstractStringValueStream {
    private final StringValueStream baseExpr;
    private final StringValue compExpr;
    private final StringValue fillExpr;
    public static final String name = "replace";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public StringStreamReplaceFunction(StringValueStream baseExpr, StringValue compExpr, StringValue fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        String compValue = this.compExpr.toString();
        if (this.compExpr.exists()) {
            String fillValue = this.fillExpr.toString();
            boolean fillExists = this.fillExpr.exists();
            this.baseExpr.streamStrings(value -> {
                if (value.equals(compValue)) {
                    if (fillExists) {
                        cons.accept(fillValue);
                    }
                } else {
                    cons.accept((String)value);
                }
            });
        } else {
            this.baseExpr.streamStrings(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

