/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

class StringStreamRemoveFunction
extends StringValueStream.AbstractStringValueStream {
    private final StringValueStream baseExpr;
    private final StringValue removeExpr;
    public static final String name = "remove";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public StringStreamRemoveFunction(StringValueStream baseExpr, StringValue removeExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.removeExpr = removeExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, removeExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        String removeValue = this.removeExpr.toString();
        if (this.removeExpr.exists()) {
            this.baseExpr.streamStrings(value -> {
                if (removeValue.equals(value)) {
                    cons.accept((String)value);
                }
            });
        } else {
            this.baseExpr.streamStrings(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

