/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.common.SolrException;

class StreamRemoveFunction
implements AnalyticsValueStream {
    private final AnalyticsValueStream baseExpr;
    private final AnalyticsValue removeExpr;
    public static final String name = "remove";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public StreamRemoveFunction(AnalyticsValueStream baseExpr, AnalyticsValue removeExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.removeExpr = removeExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, removeExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        Object removeValue = this.removeExpr.getObject();
        if (this.removeExpr.exists()) {
            this.baseExpr.streamObjects(value -> {
                if (removeValue.equals(value)) {
                    cons.accept(value);
                }
            });
        } else {
            this.baseExpr.streamObjects(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

