/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.LongConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.common.SolrException;

class LongStreamRemoveFunction
extends LongValueStream.AbstractLongValueStream {
    private final LongValueStream baseExpr;
    private final LongValue removeExpr;
    public static final String name = "remove";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public LongStreamRemoveFunction(LongValueStream baseExpr, LongValue removeExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.removeExpr = removeExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, removeExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        long removeValue = this.removeExpr.getLong();
        if (this.removeExpr.exists()) {
            this.baseExpr.streamLongs(value -> {
                if (removeValue == value) {
                    cons.accept(value);
                }
            });
        } else {
            this.baseExpr.streamLongs(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

