/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.analytics.value.constant.ConstantStringValue;
import org.apache.solr.common.SolrException;

public class JoinFunction {
    public static final String name = "join";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The join function requires 2 parameters.");
        }
        AnalyticsValueStream param1 = params[0];
        AnalyticsValueStream param2 = params[1];
        if (!(param2 instanceof ConstantStringValue)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The join function requires the second parameter to be a constant string");
        }
        String sep = ((StringValue)param2).getString();
        if (!(param1 instanceof StringValueStream)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The join function requires the first parameter to be castable to a string");
        }
        if (param1 instanceof StringValue) {
            return param1;
        }
        String uniqueName = "join(" + sep + ")";
        return LambdaFunction.createStringLambdaFunction(uniqueName, (a, b) -> a + sep + b, (StringValueStream)params[0]);
    };
}

