/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.common.SolrException;

class IntReplaceFunction
extends IntValue.AbstractIntValue {
    private final IntValue baseExpr;
    private final IntValue compExpr;
    private final IntValue fillExpr;
    public static final String name = "replace";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;

    public IntReplaceFunction(IntValue baseExpr, IntValue compExpr, IntValue fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
    }

    @Override
    public int getInt() {
        int value = this.baseExpr.getInt();
        this.exists = this.baseExpr.exists();
        int comp = this.compExpr.getInt();
        if (value == comp && this.exists == this.compExpr.exists()) {
            value = this.fillExpr.getInt();
            this.exists = this.fillExpr.exists();
        }
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

