/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.BooleanIfFunction;
import org.apache.solr.analytics.function.mapping.BooleanStreamIfFunction;
import org.apache.solr.analytics.function.mapping.DateIfFunction;
import org.apache.solr.analytics.function.mapping.DateStreamIfFunction;
import org.apache.solr.analytics.function.mapping.DoubleIfFunction;
import org.apache.solr.analytics.function.mapping.DoubleStreamIfFunction;
import org.apache.solr.analytics.function.mapping.FloatIfFunction;
import org.apache.solr.analytics.function.mapping.FloatStreamIfFunction;
import org.apache.solr.analytics.function.mapping.IntIfFunction;
import org.apache.solr.analytics.function.mapping.IntStreamIfFunction;
import org.apache.solr.analytics.function.mapping.LongIfFunction;
import org.apache.solr.analytics.function.mapping.LongStreamIfFunction;
import org.apache.solr.analytics.function.mapping.StringIfFunction;
import org.apache.solr.analytics.function.mapping.StringStreamIfFunction;
import org.apache.solr.analytics.function.mapping.ValueIfFunction;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class IfFunction
implements AnalyticsValueStream {
    private final BooleanValue ifExpr;
    private final AnalyticsValueStream thenExpr;
    private final AnalyticsValueStream elseExpr;
    public static final String name = "if";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 3) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The if function requires 3 paramaters, " + params.length + " found.");
        }
        if (!(params[0] instanceof BooleanValue)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The if function requires single-valued numeric parameters. Incorrect parameter: " + params[0].getExpressionStr());
        }
        BooleanValue castedIf = (BooleanValue)params[0];
        AnalyticsValueStream thenExpr = params[1];
        AnalyticsValueStream elseExpr = params[2];
        if (thenExpr instanceof DateValue && elseExpr instanceof DateValue) {
            return new DateIfFunction(castedIf, (DateValue)thenExpr, (DateValue)elseExpr);
        }
        if (thenExpr instanceof DateValueStream && elseExpr instanceof DateValueStream) {
            return new DateStreamIfFunction(castedIf, (DateValueStream)thenExpr, (DateValueStream)elseExpr);
        }
        if (thenExpr instanceof BooleanValue && elseExpr instanceof BooleanValue) {
            return new BooleanIfFunction(castedIf, (BooleanValue)thenExpr, (BooleanValue)elseExpr);
        }
        if (thenExpr instanceof BooleanValueStream && elseExpr instanceof BooleanValueStream) {
            return new BooleanStreamIfFunction(castedIf, (BooleanValueStream)thenExpr, (BooleanValueStream)elseExpr);
        }
        if (thenExpr instanceof IntValue && elseExpr instanceof IntValue) {
            return new IntIfFunction(castedIf, (IntValue)thenExpr, (IntValue)elseExpr);
        }
        if (thenExpr instanceof IntValueStream && elseExpr instanceof IntValueStream) {
            return new IntStreamIfFunction(castedIf, (IntValueStream)thenExpr, (IntValueStream)elseExpr);
        }
        if (thenExpr instanceof LongValue && elseExpr instanceof LongValue) {
            return new LongIfFunction(castedIf, (LongValue)thenExpr, (LongValue)elseExpr);
        }
        if (thenExpr instanceof LongValueStream && elseExpr instanceof LongValueStream) {
            return new LongStreamIfFunction(castedIf, (LongValueStream)thenExpr, (LongValueStream)elseExpr);
        }
        if (thenExpr instanceof FloatValue && elseExpr instanceof FloatValue) {
            return new FloatIfFunction(castedIf, (FloatValue)thenExpr, (FloatValue)elseExpr);
        }
        if (thenExpr instanceof FloatValueStream && elseExpr instanceof FloatValueStream) {
            return new FloatStreamIfFunction(castedIf, (FloatValueStream)thenExpr, (FloatValueStream)elseExpr);
        }
        if (thenExpr instanceof DoubleValue && elseExpr instanceof DoubleValue) {
            return new DoubleIfFunction(castedIf, (DoubleValue)thenExpr, (DoubleValue)elseExpr);
        }
        if (thenExpr instanceof DoubleValueStream && elseExpr instanceof DoubleValueStream) {
            return new DoubleStreamIfFunction(castedIf, (DoubleValueStream)thenExpr, (DoubleValueStream)elseExpr);
        }
        if (thenExpr instanceof StringValue && elseExpr instanceof StringValue) {
            return new StringIfFunction(castedIf, (StringValue)thenExpr, (StringValue)elseExpr);
        }
        if (thenExpr instanceof StringValueStream && elseExpr instanceof StringValueStream) {
            return new StringStreamIfFunction(castedIf, (StringValueStream)thenExpr, (StringValueStream)elseExpr);
        }
        if (thenExpr instanceof AnalyticsValue && elseExpr instanceof AnalyticsValue) {
            return new ValueIfFunction(castedIf, (AnalyticsValue)thenExpr, (AnalyticsValue)elseExpr);
        }
        return new IfFunction(castedIf, thenExpr, elseExpr);
    };

    public IfFunction(BooleanValue ifExpr, AnalyticsValueStream thenExpr, AnalyticsValueStream elseExpr) throws SolrException {
        this.ifExpr = ifExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, ifExpr, thenExpr, elseExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        boolean ifValue = this.ifExpr.getBoolean();
        if (this.ifExpr.exists()) {
            if (ifValue) {
                this.thenExpr.streamObjects(cons);
            } else {
                this.elseExpr.streamObjects(cons);
            }
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

