/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.common.SolrException;

class FloatStreamFillMissingFunction
extends FloatValueStream.AbstractFloatValueStream
implements FloatConsumer {
    private final FloatValueStream baseExpr;
    private final FloatValueStream fillExpr;
    public static final String name = "fillmissing";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;
    FloatConsumer cons;

    public FloatStreamFillMissingFunction(FloatValueStream baseExpr, FloatValueStream fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
    }

    @Override
    public void streamFloats(FloatConsumer cons) {
        this.exists = false;
        this.cons = cons;
        this.baseExpr.streamFloats(this);
        if (!this.exists) {
            this.fillExpr.streamFloats(cons);
        }
    }

    @Override
    public void accept(float value) {
        this.exists = true;
        this.cons.accept(value);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

