/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.DoubleConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

class DoubleStreamFillMissingFunction
extends DoubleValueStream.AbstractDoubleValueStream
implements DoubleConsumer {
    private final DoubleValueStream baseExpr;
    private final DoubleValueStream fillExpr;
    public static final String name = "fillmissing";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;
    DoubleConsumer cons;

    public DoubleStreamFillMissingFunction(DoubleValueStream baseExpr, DoubleValueStream fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        this.exists = false;
        this.cons = cons;
        this.baseExpr.streamDoubles(this);
        if (!this.exists) {
            this.fillExpr.streamDoubles(cons);
        }
    }

    @Override
    public void accept(double value) {
        this.exists = true;
        this.cons.accept(value);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

