/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.ConvertFloatFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.IntValue;

class ConvertFloatValueFunction
extends IntValue.AbstractIntValue {
    private final String name;
    private final FloatValue param;
    private final ConvertFloatFunction conv;
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public ConvertFloatValueFunction(String name, FloatValue param, ConvertFloatFunction conv) {
        this.name = name;
        this.param = param;
        this.conv = conv;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, param);
    }

    @Override
    public int getInt() {
        return this.conv.convert(this.param.getFloat());
    }

    @Override
    public boolean exists() {
        return this.param.exists();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

