/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.IntConsumer;
import org.apache.solr.analytics.function.mapping.ConvertFloatFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;

class ConvertFloatStreamFunction
extends IntValueStream.AbstractIntValueStream {
    private final String name;
    private final FloatValueStream param;
    private final ConvertFloatFunction conv;
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public ConvertFloatStreamFunction(String name, FloatValueStream param, ConvertFloatFunction conv) {
        this.name = name;
        this.param = param;
        this.conv = conv;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, param);
    }

    @Override
    public void streamInts(IntConsumer cons) {
        this.param.streamFloats(value -> cons.accept(this.conv.convert(value)));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

