/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.CompResultFunction;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

class CompareStringStreamFunction
extends BooleanValueStream.AbstractBooleanValueStream {
    private final StringValue baseExpr;
    private final StringValueStream compExpr;
    private final CompResultFunction comp;
    private final String name;
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public CompareStringStreamFunction(String name, StringValue baseExpr, StringValueStream compExpr, CompResultFunction comp) throws SolrException {
        this.name = name;
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.comp = comp;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, baseExpr, compExpr);
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        String baseValue = this.baseExpr.toString();
        if (this.baseExpr.exists()) {
            this.compExpr.streamStrings(compValue -> cons.accept(this.comp.apply(baseValue.compareTo((String)compValue))));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

