/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class BottomFunction {
    public static final String name = "bottom";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        int i;
        boolean tryNextType;
        AnalyticsValue[] castedParams;
        if (params.length == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The bottom function requires paramaters.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof DateValueStream) {
            if (params.length == 1) {
                return LambdaFunction.createDateLambdaFunction(name, (a, b) -> a < b ? a : b, (DateValueStream)param);
            }
            castedParams = new DateValue[params.length];
            tryNextType = false;
            for (i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof DateValue)) {
                    tryNextType = true;
                    break;
                }
                castedParams[i] = (DateValue)params[i];
            }
            if (!tryNextType) {
                return LambdaFunction.createDateLambdaFunction(name, (a, b) -> a < b ? a : b, (DateValue[])castedParams, false);
            }
        }
        if (param instanceof IntValueStream) {
            if (params.length == 1) {
                return LambdaFunction.createIntLambdaFunction(name, (a, b) -> a < b ? a : b, (IntValueStream)param);
            }
            castedParams = new IntValue[params.length];
            tryNextType = false;
            for (i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof IntValue)) {
                    tryNextType = true;
                    break;
                }
                castedParams[i] = (IntValue)params[i];
            }
            if (!tryNextType) {
                return LambdaFunction.createIntLambdaFunction(name, (a, b) -> a < b ? a : b, (IntValue[])castedParams, false);
            }
        }
        if (param instanceof LongValueStream) {
            if (params.length == 1) {
                return LambdaFunction.createLongLambdaFunction(name, (a, b) -> a < b ? a : b, (LongValueStream)param);
            }
            castedParams = new LongValue[params.length];
            tryNextType = false;
            for (i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof LongValue)) {
                    tryNextType = true;
                    break;
                }
                castedParams[i] = (LongValue)params[i];
            }
            if (!tryNextType) {
                return LambdaFunction.createLongLambdaFunction(name, (a, b) -> a < b ? a : b, (LongValue[])castedParams, false);
            }
        }
        if (param instanceof FloatValueStream) {
            if (params.length == 1) {
                return LambdaFunction.createFloatLambdaFunction(name, (a, b) -> a < b ? a : b, (FloatValueStream)param);
            }
            castedParams = new FloatValue[params.length];
            tryNextType = false;
            for (i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof FloatValue)) {
                    tryNextType = true;
                    break;
                }
                castedParams[i] = (FloatValue)params[i];
            }
            if (!tryNextType) {
                return LambdaFunction.createFloatLambdaFunction(name, (a, b) -> a < b ? a : b, (FloatValue[])castedParams, false);
            }
        }
        if (param instanceof DoubleValueStream) {
            if (params.length == 1) {
                return LambdaFunction.createDoubleLambdaFunction(name, (a, b) -> a < b ? a : b, (DoubleValueStream)param);
            }
            castedParams = new DoubleValue[params.length];
            tryNextType = false;
            for (i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof DoubleValue)) {
                    tryNextType = true;
                    break;
                }
                castedParams[i] = (DoubleValue)params[i];
            }
            if (!tryNextType) {
                return LambdaFunction.createDoubleLambdaFunction(name, (a, b) -> a < b ? a : b, (DoubleValue[])castedParams, false);
            }
        }
        if (param instanceof StringValueStream) {
            if (params.length == 1) {
                return LambdaFunction.createStringLambdaFunction(name, (a, b) -> a.compareTo(b) <= 0 ? a : b, (StringValueStream)param);
            }
            castedParams = new StringValue[params.length];
            tryNextType = false;
            for (i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof StringValue)) {
                    tryNextType = true;
                    break;
                }
                castedParams[i] = (StringValue)params[i];
            }
            if (!tryNextType) {
                return LambdaFunction.createStringLambdaFunction(name, (a, b) -> a.compareTo(b) <= 0 ? a : b, (StringValue[])castedParams, false);
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The bottom function requires a comparable parameter. Incorrect parameter: " + params[0].getExpressionStr());
    };
}

