/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.request;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.solr.analytics.accumulator.BasicAccumulator;
import org.apache.solr.analytics.accumulator.FacetingAccumulator;
import org.apache.solr.analytics.accumulator.ValueAccumulator;
import org.apache.solr.analytics.plugin.AnalyticsStatisticsCollector;
import org.apache.solr.analytics.request.AnalyticsRequest;
import org.apache.solr.analytics.request.AnalyticsRequestFactory;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsStats {
    protected DocSet docs;
    protected SolrParams params;
    protected SolrIndexSearcher searcher;
    protected SolrQueryRequest req;
    protected AnalyticsStatisticsCollector statsCollector;
    private static final Logger log = LoggerFactory.getLogger(AnalyticsStats.class);

    public AnalyticsStats(SolrQueryRequest req, DocSet docs, SolrParams params, AnalyticsStatisticsCollector statsCollector) {
        this.req = req;
        this.searcher = req.getSearcher();
        this.docs = docs;
        this.params = params;
        this.statsCollector = statsCollector;
    }

    public NamedList<?> execute() throws IOException {
        this.statsCollector.startRequest();
        NamedList res = new NamedList();
        List<AnalyticsRequest> requests = AnalyticsRequestFactory.parse(this.searcher.getSchema(), this.params);
        if (requests == null || requests.size() == 0) {
            return res;
        }
        this.statsCollector.addRequests(requests.size());
        Filter filter = this.docs.getTopFilter();
        for (AnalyticsRequest areq : requests) {
            BasicAccumulator accumulator;
            int facets = areq.getFieldFacets().size() + areq.getRangeFacets().size() + areq.getQueryFacets().size();
            try {
                accumulator = facets == 0 ? BasicAccumulator.create(this.searcher, this.docs, areq) : FacetingAccumulator.create(this.searcher, this.docs, areq, this.req);
            }
            catch (IOException e) {
                log.warn("Analytics request '" + areq.getName() + "' failed", (Throwable)e);
                continue;
            }
            this.statsCollector.addStatsCollected(accumulator.getNumStatsCollectors());
            this.statsCollector.addStatsRequests(areq.getExpressions().size());
            this.statsCollector.addFieldFacets(areq.getFieldFacets().size());
            this.statsCollector.addRangeFacets(areq.getRangeFacets().size());
            this.statsCollector.addQueryFacets(areq.getQueryFacets().size());
            this.statsCollector.addQueries(accumulator.getNumQueries());
            List contexts = this.searcher.getTopReaderContext().leaves();
            for (int leafNum = 0; leafNum < contexts.size(); ++leafNum) {
                LeafReaderContext context = (LeafReaderContext)contexts.get(leafNum);
                DocIdSet dis = filter.getDocIdSet(context, null);
                DocIdSetIterator disi = null;
                if (dis != null) {
                    disi = dis.iterator();
                }
                if (disi == null) continue;
                accumulator.getLeafCollector(context);
                int doc = disi.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    accumulator.collect(doc);
                    doc = disi.nextDoc();
                }
            }
            accumulator.postProcess();
            ((ValueAccumulator)accumulator).compute();
            res.add(areq.getName(), ((ValueAccumulator)accumulator).export());
        }
        this.statsCollector.endRequest();
        return res;
    }
}

