/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.solr.common.params.FacetParams;

public interface AnalyticsParams {
    public static final String ANALYTICS = "olap";
    public static final String REQUEST = "o|olap";
    public static final String EXPRESSION = "s|stat|statistic";
    public static final String HIDDEN_EXPRESSION = "hs|hiddenstat|hiddenstatistic";
    public static final String FIELD_FACET = "ff|fieldfacet";
    public static final String LIMIT = "l|limit";
    public static final String OFFSET = "off|offset";
    public static final String HIDDEN = "h|hidden";
    public static final String SHOW_MISSING = "sm|showmissing";
    public static final String SORT_STATISTIC = "ss|sortstat|sortstatistic";
    public static final String SORT_DIRECTION = "sd|sortdirection";
    public static final String RANGE_FACET = "rf|rangefacet";
    public static final String START = "st|start";
    public static final String END = "e|end";
    public static final String GAP = "g|gap";
    public static final String HARDEND = "he|hardend";
    public static final String INCLUDE_BOUNDARY = "ib|includebound";
    public static final String OTHER_RANGE = "or|otherrange";
    public static final String QUERY_FACET = "qf|queryfacet";
    public static final String DEPENDENCY = "d|dependecy";
    public static final String QUERY = "q|query";
    public static final boolean DEFAULT_ABBREVIATE_PREFIX = true;
    public static final String DEFAULT_SORT_DIRECTION = "ascending";
    public static final int DEFAULT_LIMIT = -1;
    public static final boolean DEFAULT_HIDDEN = false;
    public static final boolean DEFAULT_HARDEND = false;
    public static final boolean DEFAULT_SHOW_MISSING = false;
    public static final FacetParams.FacetRangeInclude DEFAULT_INCLUDE = FacetParams.FacetRangeInclude.LOWER;
    public static final FacetParams.FacetRangeOther DEFAULT_OTHER = FacetParams.FacetRangeOther.NONE;
    public static final String STAT_COUNT = "count";
    public static final String STAT_MISSING = "missing";
    public static final String STAT_SUM = "sum";
    public static final String STAT_SUM_OF_SQUARES = "sumofsquares";
    public static final String STAT_STANDARD_DEVIATION = "stddev";
    public static final String STAT_MEAN = "mean";
    public static final String STAT_UNIQUE = "unique";
    public static final String STAT_MEDIAN = "median";
    public static final String STAT_PERCENTILE = "percentile";
    public static final String STAT_MIN = "min";
    public static final String STAT_MAX = "max";
    public static final List<String> ALL_STAT_LIST = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"count", "missing", "sum", "sumofsquares", "stddev", "mean", "unique", "median", "percentile", "min", "max"}));
    public static final Set<String> ALL_STAT_SET = Collections.unmodifiableSet(Sets.newLinkedHashSet(ALL_STAT_LIST));
    public static final String FILTER = "filter";
    public static final String RESULT = "result";
    public static final String QUERY_RESULT = "qresult";
    public static final String CONSTANT_NUMBER = "const_num";
    public static final String NEGATE = "neg";
    public static final String ABSOLUTE_VALUE = "abs";
    public static final String LOG = "log";
    public static final String ADD = "add";
    public static final String MULTIPLY = "mult";
    public static final String DIVIDE = "div";
    public static final String POWER = "pow";
    public static final Set<String> NUMERIC_OPERATION_SET = Collections.unmodifiableSet(Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"const_num", "neg", "abs", "log", "add", "mult", "div", "pow"})));
    public static final String CONSTANT_DATE = "const_date";
    public static final String DATE_MATH = "date_math";
    public static final Set<String> DATE_OPERATION_SET = Collections.unmodifiableSet(Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"const_date", "date_math"})));
    public static final String CONSTANT_STRING = "const_str";
    public static final String REVERSE = "rev";
    public static final String CONCATENATE = "concat";
    public static final Set<String> STRING_OPERATION_SET = Collections.unmodifiableSet(Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"const_str", "rev", "concat"})));
}

