/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.junit;

import java.util.Map;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.apache.sling.testing.mock.sling.junit.SlingContextCallback;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class SlingContext
extends SlingContextImpl
implements TestRule {
    private final SlingContextCallback beforeSetUpCallback;
    private final SlingContextCallback afterSetUpCallback;
    private final SlingContextCallback beforeTearDownCallback;
    private final SlingContextCallback afterTearDownCallback;
    private final TestRule delegate;

    public SlingContext() {
        this(null, null, null);
    }

    public SlingContext(ResourceResolverType resourceResolverType) {
        this(null, null, resourceResolverType);
    }

    public SlingContext(SlingContextCallback afterSetUpCallback) {
        this(afterSetUpCallback, null, null);
    }

    public SlingContext(SlingContextCallback afterSetUpCallback, ResourceResolverType resourceResolverType) {
        this(afterSetUpCallback, null, resourceResolverType);
    }

    public SlingContext(SlingContextCallback afterSetUpCallback, SlingContextCallback beforeTearDownCallback) {
        this(afterSetUpCallback, beforeTearDownCallback, null);
    }

    public SlingContext(SlingContextCallback afterSetUpCallback, SlingContextCallback beforeTearDownCallback, ResourceResolverType resourceResolverType) {
        this(null, afterSetUpCallback, beforeTearDownCallback, null, null, resourceResolverType);
    }

    SlingContext(SlingContextCallback beforeSetUpCallback, SlingContextCallback afterSetUpCallback, SlingContextCallback beforeTearDownCallback, SlingContextCallback afterTearDownCallback, Map<String, Object> resourceResolverFactoryActivatorProps, ResourceResolverType resourceResolverType) {
        this.beforeSetUpCallback = beforeSetUpCallback;
        this.afterSetUpCallback = afterSetUpCallback;
        this.beforeTearDownCallback = beforeTearDownCallback;
        this.afterTearDownCallback = afterTearDownCallback;
        this.setResourceResolverFactoryActivatorProps(resourceResolverFactoryActivatorProps);
        this.setResourceResolverType(resourceResolverType);
        this.delegate = new ExternalResource(){

            protected void before() {
                SlingContext.this.executeBeforeSetUpCallback();
                SlingContext.this.setUp();
                SlingContext.this.executeAfterSetUpCallback();
            }

            protected void after() {
                SlingContext.this.executeBeforeTearDownCallback();
                SlingContext.this.tearDown();
                SlingContext.this.executeAfterTearDownCallback();
            }
        };
    }

    public Statement apply(Statement base, Description description) {
        return this.delegate.apply(base, description);
    }

    private void executeBeforeSetUpCallback() {
        if (this.beforeSetUpCallback != null) {
            try {
                this.beforeSetUpCallback.execute(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Before setup failed: " + ex.getMessage(), ex);
            }
        }
    }

    private void executeAfterSetUpCallback() {
        if (this.afterSetUpCallback != null) {
            try {
                this.afterSetUpCallback.execute(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException("After setup failed: " + ex.getMessage(), ex);
            }
        }
    }

    private void executeBeforeTearDownCallback() {
        if (this.beforeTearDownCallback != null) {
            try {
                this.beforeTearDownCallback.execute(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Before teardown failed: " + ex.getMessage(), ex);
            }
        }
    }

    private void executeAfterTearDownCallback() {
        if (this.afterTearDownCallback != null) {
            try {
                this.afterTearDownCallback.execute(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException("After teardown failed: " + ex.getMessage(), ex);
            }
        }
    }
}

