/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProvider;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryActivator;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.apache.sling.testing.mock.osgi.MockEventAdmin;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockDynamicClassLoaderManager;
import org.apache.sling.testing.mock.sling.NodeTypeDefinitionScanner;
import org.apache.sling.testing.mock.sling.NodeTypeMode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;

class ResourceResolverFactoryInitializer {
    private ResourceResolverFactoryInitializer() {
    }

    public static ResourceResolverFactory setUp(SlingRepository slingRepository, BundleContext bundleContext, NodeTypeMode nodeTypeMode) {
        if (slingRepository != null) {
            ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, SlingRepository.class, slingRepository);
            ResourceResolverFactoryInitializer.registerJcrNodeTypes(slingRepository, nodeTypeMode);
            ResourceResolverFactoryInitializer.ensureJcrResourceProviderDependencies(bundleContext);
            ResourceResolverFactoryInitializer.initializeJcrResourceProvider(bundleContext);
        }
        ResourceResolverFactoryInitializer.ensureResourceResolverFactoryActivatorDependencies(bundleContext);
        ResourceResolverFactoryInitializer.initializeResourceResolverFactoryActivator(bundleContext);
        ServiceReference factoryRef = bundleContext.getServiceReference(ResourceResolverFactory.class);
        if (factoryRef == null) {
            throw new IllegalStateException("Unable to get ResourceResolverFactory.");
        }
        return (ResourceResolverFactory)bundleContext.getService(factoryRef);
    }

    private static void ensureJcrResourceProviderDependencies(BundleContext bundleContext) {
        if (bundleContext.getServiceReference(DynamicClassLoaderManager.class) == null) {
            bundleContext.registerService(DynamicClassLoaderManager.class, (Object)new MockDynamicClassLoaderManager(), null);
        }
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, PathMapper.class, new PathMapper());
    }

    private static void initializeJcrResourceProvider(BundleContext bundleContext) {
        Hashtable config = new Hashtable();
        JcrResourceProvider factory = new JcrResourceProvider();
        MockOsgi.injectServices((Object)factory, (BundleContext)bundleContext);
        MockOsgi.activate((Object)factory, (BundleContext)bundleContext, config);
        bundleContext.registerService(ResourceProvider.class, (Object)factory, config);
    }

    private static void ensureResourceResolverFactoryActivatorDependencies(BundleContext bundleContext) {
        Hashtable<String, Object> config = new Hashtable<String, Object>();
        ((Dictionary)config).put("user.mapping", bundleContext.getBundle().getSymbolicName() + "=admin");
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, ServiceUserMapper.class, new ServiceUserMapperImpl(), config);
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, ResourceAccessSecurityTracker.class, new ResourceAccessSecurityTracker());
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, EventAdmin.class, new MockEventAdmin());
    }

    private static void initializeResourceResolverFactoryActivator(BundleContext bundleContext) {
        Hashtable config = new Hashtable();
        ResourceResolverFactoryActivator activator = new ResourceResolverFactoryActivator();
        MockOsgi.injectServices((Object)activator, (BundleContext)bundleContext);
        MockOsgi.activate((Object)activator, (BundleContext)bundleContext, config);
        bundleContext.registerService(ResourceResolverFactoryActivator.class.getName(), (Object)activator, config);
    }

    private static <T> void registerServiceIfNotPresent(BundleContext bundleContext, Class<T> serviceClass, T instance) {
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, serviceClass, instance, new Hashtable<String, Object>());
    }

    private static <T> void registerServiceIfNotPresent(BundleContext bundleContext, Class<T> serviceClass, T instance, Dictionary<String, Object> config) {
        if (bundleContext.getServiceReference(serviceClass.getName()) == null) {
            MockOsgi.injectServices(instance, (BundleContext)bundleContext);
            MockOsgi.activate(instance, (BundleContext)bundleContext, config);
            bundleContext.registerService(serviceClass, instance, config);
        }
    }

    private static void registerJcrNodeTypes(SlingRepository slingRepository, NodeTypeMode nodeTypeMode) {
        Session session = null;
        try {
            session = slingRepository.loginAdministrative(null);
            NodeTypeDefinitionScanner.get().register(session, nodeTypeMode);
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Error registering JCR nodetypes: " + ex.getMessage(), ex);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

