/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefReader;
import org.apache.jackrabbit.commons.cnd.DefinitionBuilderFactory;
import org.apache.jackrabbit.commons.cnd.TemplateBuilderFactory;
import org.apache.sling.testing.mock.sling.NodeTypeMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeTypeDefinitionScanner {
    private static final NodeTypeDefinitionScanner SINGLETON = new NodeTypeDefinitionScanner();
    private static final int MAX_ITERATIONS = 5;
    private static final Logger log = LoggerFactory.getLogger(NodeTypeDefinitionScanner.class);
    private final List<String> nodeTypeDefinitions = NodeTypeDefinitionScanner.findeNodeTypeDefinitions();

    private NodeTypeDefinitionScanner() {
    }

    public List<String> getNodeTypeDefinitions() {
        return this.nodeTypeDefinitions;
    }

    public void register(Session session, NodeTypeMode nodeTypeMode) throws RepositoryException {
        List<String> nodeTypeResources = this.getNodeTypeDefinitions();
        this.register(session, nodeTypeResources, nodeTypeMode);
    }

    public void register(Session session, List<String> nodeTypeResources, NodeTypeMode nodeTypeMode) throws RepositoryException {
        switch (nodeTypeMode) {
            case NOT_SUPPORTED: {
                break;
            }
            case NAMESPACES_ONLY: {
                this.registerNamespaces(session, nodeTypeResources);
                break;
            }
            case NODETYPES_REQUIRED: {
                this.registerNodeTypes(session, nodeTypeResources);
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type mode not supported: " + (Object)((Object)nodeTypeMode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNamespaces(Session session, List<String> nodeTypeResources) throws RepositoryException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Workspace workspace = session.getWorkspace();
        NamespaceRegistry namespaceRegistry = workspace.getNamespaceRegistry();
        ValueFactory valueFactory = session.getValueFactory();
        TemplateBuilderFactory factory = new TemplateBuilderFactory((NodeTypeManager)new DummyNodeTypeManager(), valueFactory, namespaceRegistry);
        for (String nodeTypeResource : nodeTypeResources) {
            InputStream is = classLoader.getResourceAsStream(nodeTypeResource);
            if (is == null) continue;
            try {
                InputStreamReader reader = new InputStreamReader(is);
                CompactNodeTypeDefReader cndReader = new CompactNodeTypeDefReader((Reader)reader, nodeTypeResource, (DefinitionBuilderFactory)factory);
                NamespaceRegistry mapping = (NamespaceRegistry)cndReader.getNamespaceMapping();
                for (int i = 0; i < mapping.getURIs().length; ++i) {
                    String uri = mapping.getURIs()[i];
                    String prefix = mapping.getPrefix(uri);
                    try {
                        namespaceRegistry.registerNamespace(prefix, uri);
                        continue;
                    }
                    catch (RepositoryException repositoryException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable ex) {
                log.warn("Unable to parse node type definition: " + nodeTypeResource, ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    private void registerNodeTypes(Session session, List<String> nodeTypeResources) throws RepositoryException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Workspace workspace = session.getWorkspace();
        NodeTypeManager nodeTypeManager = workspace.getNodeTypeManager();
        NamespaceRegistry namespaceRegistry = workspace.getNamespaceRegistry();
        ValueFactory valueFactory = session.getValueFactory();
        int iteration = 0;
        ArrayList<String> remainingNodeTypeResources = new ArrayList<String>(nodeTypeResources);
        while (!remainingNodeTypeResources.isEmpty()) {
            this.registerNodeTypesAndRemoveSucceeds(remainingNodeTypeResources, classLoader, nodeTypeManager, namespaceRegistry, valueFactory, false);
            if (++iteration < 5) continue;
        }
        if (!remainingNodeTypeResources.isEmpty()) {
            this.registerNodeTypesAndRemoveSucceeds(remainingNodeTypeResources, classLoader, nodeTypeManager, namespaceRegistry, valueFactory, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNodeTypesAndRemoveSucceeds(List<String> nodeTypeResources, ClassLoader classLoader, NodeTypeManager nodeTypeManager, NamespaceRegistry namespaceRegistry, ValueFactory valueFactory, boolean logError) {
        Iterator<String> nodeTypeResourcesIterator = nodeTypeResources.iterator();
        while (nodeTypeResourcesIterator.hasNext()) {
            String nodeTypeResource = nodeTypeResourcesIterator.next();
            InputStream is = classLoader.getResourceAsStream(nodeTypeResource);
            if (is == null) continue;
            try {
                InputStreamReader reader = new InputStreamReader(is);
                CndImporter.registerNodeTypes((Reader)reader, (String)nodeTypeResource, (NodeTypeManager)nodeTypeManager, (NamespaceRegistry)namespaceRegistry, (ValueFactory)valueFactory, (boolean)false);
                nodeTypeResourcesIterator.remove();
            }
            catch (Throwable ex) {
                if (!logError) continue;
                log.warn("Unable to register node type: " + nodeTypeResource, ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> findeNodeTypeDefinitions() {
        ArrayList<String> nodeTypeDefinitions = new ArrayList<String>();
        try {
            Enumeration<URL> resEnum = NodeTypeDefinitionScanner.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    URL url = resEnum.nextElement();
                    InputStream is = url.openStream();
                    if (is == null) continue;
                    try {
                        Manifest manifest = new Manifest(is);
                        Attributes mainAttribs = manifest.getMainAttributes();
                        String nodeTypeDefinitionList = mainAttribs.getValue("Sling-Nodetypes");
                        String[] nodeTypeDefinitionArray = StringUtils.split((String)nodeTypeDefinitionList, (String)",");
                        if (nodeTypeDefinitionArray == null) continue;
                        for (String nodeTypeDefinition : nodeTypeDefinitionArray) {
                            if (StringUtils.isBlank((CharSequence)nodeTypeDefinition)) continue;
                            nodeTypeDefinitions.add(StringUtils.trim((String)nodeTypeDefinition));
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (Throwable ex) {
                    log.warn("Unable to read JAR manifest.", ex);
                }
            }
        }
        catch (IOException ex2) {
            log.warn("Unable to read JAR manifests.", (Throwable)ex2);
        }
        return nodeTypeDefinitions;
    }

    public static NodeTypeDefinitionScanner get() {
        return SINGLETON;
    }

    private static class DummyPropertyDefinitionTemplate
    implements PropertyDefinitionTemplate {
        private DummyPropertyDefinitionTemplate() {
        }

        public int getRequiredType() {
            return 0;
        }

        public String[] getValueConstraints() {
            return null;
        }

        public Value[] getDefaultValues() {
            return null;
        }

        public boolean isMultiple() {
            return false;
        }

        public String[] getAvailableQueryOperators() {
            return null;
        }

        public boolean isFullTextSearchable() {
            return false;
        }

        public boolean isQueryOrderable() {
            return false;
        }

        public NodeType getDeclaringNodeType() {
            return null;
        }

        public String getName() {
            return null;
        }

        public boolean isAutoCreated() {
            return false;
        }

        public boolean isMandatory() {
            return false;
        }

        public int getOnParentVersion() {
            return 0;
        }

        public boolean isProtected() {
            return false;
        }

        public void setName(String name) {
        }

        public void setAutoCreated(boolean autoCreated) {
        }

        public void setMandatory(boolean mandatory) {
        }

        public void setOnParentVersion(int opv) {
        }

        public void setProtected(boolean protectedStatus) {
        }

        public void setRequiredType(int type) {
        }

        public void setValueConstraints(String[] constraints) {
        }

        public void setDefaultValues(Value[] defaultValues) {
        }

        public void setMultiple(boolean multiple) {
        }

        public void setAvailableQueryOperators(String[] operators) {
        }

        public void setFullTextSearchable(boolean fullTextSearchable) {
        }

        public void setQueryOrderable(boolean queryOrderable) {
        }
    }

    private static class DummyNodeDefinitionTemplate
    implements NodeDefinitionTemplate {
        private DummyNodeDefinitionTemplate() {
        }

        public NodeType[] getRequiredPrimaryTypes() {
            return null;
        }

        public String[] getRequiredPrimaryTypeNames() {
            return null;
        }

        public NodeType getDefaultPrimaryType() {
            return null;
        }

        public String getDefaultPrimaryTypeName() {
            return null;
        }

        public boolean allowsSameNameSiblings() {
            return false;
        }

        public NodeType getDeclaringNodeType() {
            return null;
        }

        public String getName() {
            return null;
        }

        public boolean isAutoCreated() {
            return false;
        }

        public boolean isMandatory() {
            return false;
        }

        public int getOnParentVersion() {
            return 0;
        }

        public boolean isProtected() {
            return false;
        }

        public void setName(String name) {
        }

        public void setAutoCreated(boolean autoCreated) {
        }

        public void setMandatory(boolean mandatory) {
        }

        public void setOnParentVersion(int opv) {
        }

        public void setProtected(boolean protectedStatus) {
        }

        public void setRequiredPrimaryTypeNames(String[] names) {
        }

        public void setDefaultPrimaryTypeName(String name) {
        }

        public void setSameNameSiblings(boolean allowSameNameSiblings) {
        }
    }

    private static class DummyNodeTypeTemplate
    implements NodeTypeTemplate {
        private DummyNodeTypeTemplate() {
        }

        public String getName() {
            return null;
        }

        public String[] getDeclaredSupertypeNames() {
            return null;
        }

        public boolean isAbstract() {
            return false;
        }

        public boolean isMixin() {
            return false;
        }

        public boolean hasOrderableChildNodes() {
            return false;
        }

        public boolean isQueryable() {
            return false;
        }

        public String getPrimaryItemName() {
            return null;
        }

        public PropertyDefinition[] getDeclaredPropertyDefinitions() {
            return null;
        }

        public NodeDefinition[] getDeclaredChildNodeDefinitions() {
            return null;
        }

        public void setName(String name) {
        }

        public void setDeclaredSuperTypeNames(String[] names) {
        }

        public void setAbstract(boolean abstractStatus) {
        }

        public void setMixin(boolean mixin) {
        }

        public void setOrderableChildNodes(boolean orderable) {
        }

        public void setPrimaryItemName(String name) {
        }

        public void setQueryable(boolean queryable) {
        }

        public List getPropertyDefinitionTemplates() {
            return new ArrayList();
        }

        public List getNodeDefinitionTemplates() {
            return new ArrayList();
        }
    }

    private static class DummyNodeTypeManager
    implements NodeTypeManager {
        private DummyNodeTypeManager() {
        }

        public NodeType getNodeType(String nodeTypeName) {
            return null;
        }

        public boolean hasNodeType(String name) {
            return false;
        }

        public NodeTypeIterator getAllNodeTypes() {
            return null;
        }

        public NodeTypeIterator getPrimaryNodeTypes() {
            return null;
        }

        public NodeTypeIterator getMixinNodeTypes() {
            return null;
        }

        public NodeTypeTemplate createNodeTypeTemplate() {
            return new DummyNodeTypeTemplate();
        }

        public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) {
            return new DummyNodeTypeTemplate();
        }

        public NodeDefinitionTemplate createNodeDefinitionTemplate() {
            return new DummyNodeDefinitionTemplate();
        }

        public PropertyDefinitionTemplate createPropertyDefinitionTemplate() {
            return new DummyPropertyDefinitionTemplate();
        }

        public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) {
            return null;
        }

        public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) {
            return null;
        }

        public void unregisterNodeType(String name) {
        }

        public void unregisterNodeTypes(String[] names) {
        }
    }
}

