/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.testing.mock.sling.MockSlingScriptHelper;
import org.apache.sling.testing.mock.sling.ResourceResolverFactoryInitializer;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.ThreadsafeMockAdapterManagerWrapper;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletResponse;
import org.apache.sling.testing.mock.sling.spi.ResourceResolverTypeAdapter;
import org.osgi.framework.BundleContext;

public final class MockSling {
    public static final ResourceResolverType DEFAULT_RESOURCERESOLVER_TYPE = ResourceResolverType.RESOURCERESOLVER_MOCK;
    private static final ThreadsafeMockAdapterManagerWrapper ADAPTER_MANAGER = new ThreadsafeMockAdapterManagerWrapper();

    private MockSling() {
    }

    public static ResourceResolverFactory newResourceResolverFactory(BundleContext bundleContext) {
        return MockSling.newResourceResolverFactory(DEFAULT_RESOURCERESOLVER_TYPE, bundleContext);
    }

    public static ResourceResolverFactory newResourceResolverFactory(ResourceResolverType type, BundleContext bundleContext) {
        ResourceResolverTypeAdapter adapter = MockSling.getResourceResolverTypeAdapter(type);
        ResourceResolverFactory factory = adapter.newResourceResolverFactory();
        if (factory == null) {
            SlingRepository repository = adapter.newSlingRepository();
            factory = ResourceResolverFactoryInitializer.setUp(repository, bundleContext, type.getNodeTypeMode());
        } else {
            bundleContext.registerService(ResourceResolverFactory.class.getName(), (Object)factory, null);
        }
        return factory;
    }

    private static ResourceResolverTypeAdapter getResourceResolverTypeAdapter(ResourceResolverType type) {
        try {
            Class<?> clazz = Class.forName(type.getResourceResolverTypeAdapterClass());
            return (ResourceResolverTypeAdapter)clazz.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to instantiate resourcer resolver: " + type.getResourceResolverTypeAdapterClass() + (type.getArtifactCoordinates() != null ? ". Make sure this maven dependency is included: " + type.getArtifactCoordinates() : ""), ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable to instantiate resourcer resolver: " + type.getResourceResolverTypeAdapterClass() + (type.getArtifactCoordinates() != null ? ". Make sure this maven dependency is included: " + type.getArtifactCoordinates() : ""), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to instantiate resourcer resolver: " + type.getResourceResolverTypeAdapterClass() + (type.getArtifactCoordinates() != null ? ". Make sure this maven dependency is included: " + type.getArtifactCoordinates() : ""), ex);
        }
    }

    public static ResourceResolver newResourceResolver(ResourceResolverType type, BundleContext bundleContext) {
        ResourceResolverFactory factory = MockSling.newResourceResolverFactory(type, bundleContext);
        try {
            return factory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException ex) {
            throw new RuntimeException("Mock resource resolver factory implementation seems to require login.", ex);
        }
    }

    public static ResourceResolver newResourceResolver(BundleContext bundleContext) {
        return MockSling.newResourceResolver(DEFAULT_RESOURCERESOLVER_TYPE, bundleContext);
    }

    public static SlingScriptHelper newSlingScriptHelper(SlingHttpServletRequest request, SlingHttpServletResponse response, BundleContext bundleContext) {
        return new MockSlingScriptHelper(request, response, bundleContext);
    }

    public static SlingScriptHelper newSlingScriptHelper(BundleContext bundleContext) {
        MockSlingHttpServletRequest request = new MockSlingHttpServletRequest(MockSling.newResourceResolver(bundleContext), bundleContext);
        MockSlingHttpServletResponse response = new MockSlingHttpServletResponse();
        return MockSling.newSlingScriptHelper((SlingHttpServletRequest)request, (SlingHttpServletResponse)response, bundleContext);
    }

    public static void setAdapterManagerBundleContext(BundleContext bundleContext) {
        ADAPTER_MANAGER.setBundleContext(bundleContext);
    }

    public static void clearAdapterManagerBundleContext() {
        ADAPTER_MANAGER.clearBundleContext();
    }

    static {
        SlingAdaptable.setAdapterManager((AdapterManager)ADAPTER_MANAGER);
    }
}

