/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;
import org.unbescape.html.HtmlEscape;

public abstract class AbstractStandardAttributeModifierTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    private final boolean removeIfEmpty;
    private final String targetAttrCompleteName;
    private AttributeDefinition targetAttributeDefinition;

    protected AbstractStandardAttributeModifierTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence, boolean removeIfEmpty) {
        this(templateMode, dialectPrefix, attrName, attrName, precedence, removeIfEmpty);
    }

    protected AbstractStandardAttributeModifierTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, String targetAttrCompleteName, int precedence, boolean removeIfEmpty) {
        super(templateMode, dialectPrefix, attrName, precedence, false);
        Validate.notNull(targetAttrCompleteName, "Complete name of target attribute cannot be null");
        this.targetAttrCompleteName = targetAttrCompleteName;
        this.removeIfEmpty = removeIfEmpty;
    }

    @Override
    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull(attributeDefinitions, "Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(this.getTemplateMode(), this.targetAttrCompleteName);
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        String newAttributeValue = HtmlEscape.escapeHtml4Xml(expressionResult == null ? null : expressionResult.toString());
        if (this.removeIfEmpty && (newAttributeValue == null || newAttributeValue.length() == 0)) {
            structureHandler.removeAttribute(this.targetAttributeDefinition.getAttributeName());
            structureHandler.removeAttribute(attributeName);
        } else {
            StandardProcessorUtils.replaceAttribute(structureHandler, attributeName, this.targetAttributeDefinition, this.targetAttrCompleteName, newAttributeValue == null ? "" : newAttributeValue);
        }
    }
}

