/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.thymeleaf.internal;

import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.thymeleaf.internal.ThymeleafScriptEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

public final class ThymeleafScriptEngine
extends AbstractSlingScriptEngine {
    private final ThymeleafScriptEngineFactory thymeleafScriptEngineFactory;
    private final Logger logger = LoggerFactory.getLogger(ThymeleafScriptEngine.class);

    public ThymeleafScriptEngine(ThymeleafScriptEngineFactory thymeleafScriptEngineFactory) {
        super((ScriptEngineFactory)((Object)thymeleafScriptEngineFactory));
        this.thymeleafScriptEngineFactory = thymeleafScriptEngineFactory;
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        Bindings bindings = scriptContext.getBindings(100);
        SlingScriptHelper helper = (SlingScriptHelper)bindings.get("sling");
        if (helper == null) {
            throw new ScriptException("SlingScriptHelper missing from bindings");
        }
        Locale locale = helper.getResponse().getLocale();
        String scriptName = helper.getScript().getScriptResource().getPath();
        Writer writer = scriptContext.getWriter();
        try {
            Context context = new Context(locale, bindings);
            this.thymeleafScriptEngineFactory.getTemplateEngine().process(scriptName, (IContext)context, writer);
        }
        catch (Exception e) {
            this.logger.error("Failure rendering Thymeleaf template '{}': {}", (Object)scriptName, (Object)e.getMessage());
            throw new ScriptException(e);
        }
        return null;
    }
}

