/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.thymeleaf.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FilenameUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.path.PathBuilder;
import org.thymeleaf.templateresource.ITemplateResource;

public class SlingTemplateResource
implements ITemplateResource {
    private final Resource resource;
    private Reader reader;

    public SlingTemplateResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public String getDescription() {
        return this.resource.getPath();
    }

    @Override
    public String getBaseName() {
        return FilenameUtils.getBaseName((String)this.resource.getName());
    }

    @Override
    public boolean exists() {
        return this.resource != null && !ResourceUtil.isNonExistingResource((Resource)this.resource);
    }

    @Override
    public Reader reader() throws IOException {
        if (this.reader == null) {
            InputStream inputStream = (InputStream)this.resource.adaptTo(InputStream.class);
            this.reader = new InputStreamReader(inputStream);
        }
        return this.reader;
    }

    @Override
    public ITemplateResource relative(String relativeLocation) {
        PathBuilder pathBuilder = new PathBuilder(this.resource.getPath());
        String path = pathBuilder.append("..").append(relativeLocation).toString();
        ResourceResolver resourceResolver = this.resource.getResourceResolver();
        Resource relative = resourceResolver.getResource(path);
        return new SlingTemplateResource(relative);
    }
}

