/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.thymeleaf.internal;

import java.util.Collections;
import java.util.HashSet;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.scripting.thymeleaf.TemplateModeProvider;
import org.apache.sling.scripting.thymeleaf.internal.PatternTemplateModeProviderConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.PatternSpec;

@Component(immediate=true, property={"service.description=Pattern TemplateModeProvider for Sling Scripting Thymeleaf", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=PatternTemplateModeProviderConfiguration.class)
public class PatternTemplateModeProvider
implements TemplateModeProvider {
    private final PatternSpec htmlPatternSpec = new PatternSpec();
    private final PatternSpec xmlPatternSpec = new PatternSpec();
    private final PatternSpec textPatternSpec = new PatternSpec();
    private final PatternSpec javascriptPatternSpec = new PatternSpec();
    private final PatternSpec cssPatternSpec = new PatternSpec();
    private final PatternSpec rawPatternSpec = new PatternSpec();
    private final Logger logger = LoggerFactory.getLogger(PatternTemplateModeProvider.class);

    @Activate
    private void activate(PatternTemplateModeProviderConfiguration configuration) {
        this.logger.debug("activating");
        this.configure(configuration);
    }

    @Modified
    private void modified(PatternTemplateModeProviderConfiguration configuration) {
        this.logger.debug("modifying");
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
    }

    private void configure(PatternTemplateModeProviderConfiguration configuration) {
        this.setPatterns(configuration.htmlPatterns(), this.htmlPatternSpec);
        this.logger.debug("configured HTML patterns: {}", this.htmlPatternSpec.getPatterns());
        this.setPatterns(configuration.xmlPatterns(), this.xmlPatternSpec);
        this.logger.debug("configured XML patterns: {}", this.xmlPatternSpec.getPatterns());
        this.setPatterns(configuration.textPatterns(), this.textPatternSpec);
        this.logger.debug("configured TEXT patterns: {}", this.textPatternSpec.getPatterns());
        this.setPatterns(configuration.javascriptPatterns(), this.javascriptPatternSpec);
        this.logger.debug("configured JAVASCRIPT patterns: {}", this.javascriptPatternSpec.getPatterns());
        this.setPatterns(configuration.cssPatterns(), this.cssPatternSpec);
        this.logger.debug("configured CSS patterns: {}", this.cssPatternSpec.getPatterns());
        this.setPatterns(configuration.rawPatterns(), this.rawPatternSpec);
        this.logger.debug("configured RAW patterns: {}", this.rawPatternSpec.getPatterns());
    }

    private void setPatterns(String[] strings, PatternSpec patternSpec) {
        HashSet<String> set = new HashSet<String>();
        if (strings != null) {
            Collections.addAll(set, strings);
        }
        patternSpec.setPatterns(set);
    }

    @Override
    public TemplateMode provideTemplateMode(Resource resource) {
        String path = resource.getPath();
        if (this.htmlPatternSpec.matches(path)) {
            return TemplateMode.HTML;
        }
        if (this.xmlPatternSpec.matches(path)) {
            return TemplateMode.XML;
        }
        if (this.textPatternSpec.matches(path)) {
            return TemplateMode.TEXT;
        }
        if (this.javascriptPatternSpec.matches(path)) {
            return TemplateMode.JAVASCRIPT;
        }
        if (this.cssPatternSpec.matches(path)) {
            return TemplateMode.CSS;
        }
        if (this.rawPatternSpec.matches(path)) {
            return TemplateMode.RAW;
        }
        return null;
    }
}

