/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.ClassResolver;
import ognl.DefaultClassResolver;
import ognl.DefaultMemberAccess;
import ognl.DefaultTypeConverter;
import ognl.Evaluation;
import ognl.MemberAccess;
import ognl.Node;
import ognl.OgnlOps;
import ognl.OgnlRuntime;
import ognl.TypeConverter;
import ognl.enhance.LocalReference;

public class OgnlContext
implements Map {
    public static final String CONTEXT_CONTEXT_KEY = "context";
    public static final String ROOT_CONTEXT_KEY = "root";
    public static final String THIS_CONTEXT_KEY = "this";
    public static final String TRACE_EVALUATIONS_CONTEXT_KEY = "_traceEvaluations";
    public static final String LAST_EVALUATION_CONTEXT_KEY = "_lastEvaluation";
    public static final String KEEP_LAST_EVALUATION_CONTEXT_KEY = "_keepLastEvaluation";
    public static final String CLASS_RESOLVER_CONTEXT_KEY = "_classResolver";
    public static final String TYPE_CONVERTER_CONTEXT_KEY = "_typeConverter";
    public static final String MEMBER_ACCESS_CONTEXT_KEY = "_memberAccess";
    private static final String PROPERTY_KEY_PREFIX = "ognl";
    private static boolean DEFAULT_TRACE_EVALUATIONS = false;
    private static boolean DEFAULT_KEEP_LAST_EVALUATION = false;
    public static final ClassResolver DEFAULT_CLASS_RESOLVER = new DefaultClassResolver();
    public static final TypeConverter DEFAULT_TYPE_CONVERTER = new DefaultTypeConverter();
    public static final MemberAccess DEFAULT_MEMBER_ACCESS = new DefaultMemberAccess(false);
    private static Map RESERVED_KEYS = new HashMap(11);
    private Object _root;
    private Object _currentObject;
    private Node _currentNode;
    private boolean _traceEvaluations = DEFAULT_TRACE_EVALUATIONS;
    private Evaluation _rootEvaluation;
    private Evaluation _currentEvaluation;
    private Evaluation _lastEvaluation;
    private boolean _keepLastEvaluation = DEFAULT_KEEP_LAST_EVALUATION;
    private final Map _values;
    private ClassResolver _classResolver = DEFAULT_CLASS_RESOLVER;
    private TypeConverter _typeConverter = DEFAULT_TYPE_CONVERTER;
    private MemberAccess _memberAccess = DEFAULT_MEMBER_ACCESS;
    private final List _typeStack = new ArrayList(3);
    private final List _accessorStack = new ArrayList(3);
    private int _localReferenceCounter = 0;
    private Map _localReferenceMap = null;

    public OgnlContext() {
        this(null, null, null);
    }

    public OgnlContext(ClassResolver classResolver, TypeConverter typeConverter, MemberAccess memberAccess) {
        this(classResolver, typeConverter, memberAccess, new HashMap(23));
    }

    public OgnlContext(Map values) {
        this(null, null, null, values);
    }

    public OgnlContext(ClassResolver classResolver, TypeConverter typeConverter, MemberAccess memberAccess, Map values) {
        this._values = values;
        if (classResolver != null) {
            this._classResolver = classResolver;
        }
        if (typeConverter != null) {
            this._typeConverter = typeConverter;
        }
        if (memberAccess != null) {
            this._memberAccess = memberAccess;
        }
    }

    public void setValues(Map value) {
        for (Object k : value.keySet()) {
            this._values.put(k, value.get(k));
        }
    }

    public Map getValues() {
        return this._values;
    }

    public void setClassResolver(ClassResolver value) {
        if (value == null) {
            throw new IllegalArgumentException("cannot set ClassResolver to null");
        }
        this._classResolver = value;
    }

    public ClassResolver getClassResolver() {
        return this._classResolver;
    }

    public void setTypeConverter(TypeConverter value) {
        if (value == null) {
            throw new IllegalArgumentException("cannot set TypeConverter to null");
        }
        this._typeConverter = value;
    }

    public TypeConverter getTypeConverter() {
        return this._typeConverter;
    }

    public void setMemberAccess(MemberAccess value) {
        if (value == null) {
            throw new IllegalArgumentException("cannot set MemberAccess to null");
        }
        this._memberAccess = value;
    }

    public MemberAccess getMemberAccess() {
        return this._memberAccess;
    }

    public void setRoot(Object value) {
        this._root = value;
        this._accessorStack.clear();
        this._typeStack.clear();
        this._currentObject = value;
        if (this._currentObject != null) {
            this.setCurrentType(this._currentObject.getClass());
        }
    }

    public Object getRoot() {
        return this._root;
    }

    public boolean getTraceEvaluations() {
        return this._traceEvaluations;
    }

    public void setTraceEvaluations(boolean value) {
        this._traceEvaluations = value;
    }

    public Evaluation getLastEvaluation() {
        return this._lastEvaluation;
    }

    public void setLastEvaluation(Evaluation value) {
        this._lastEvaluation = value;
    }

    public void recycleLastEvaluation() {
        OgnlRuntime.getEvaluationPool().recycleAll(this._lastEvaluation);
        this._lastEvaluation = null;
    }

    public boolean getKeepLastEvaluation() {
        return this._keepLastEvaluation;
    }

    public void setKeepLastEvaluation(boolean value) {
        this._keepLastEvaluation = value;
    }

    public void setCurrentObject(Object value) {
        this._currentObject = value;
    }

    public Object getCurrentObject() {
        return this._currentObject;
    }

    public void setCurrentAccessor(Class type) {
        this._accessorStack.add(type);
    }

    public Class getCurrentAccessor() {
        if (this._accessorStack.isEmpty()) {
            return null;
        }
        return (Class)this._accessorStack.get(this._accessorStack.size() - 1);
    }

    public Class getPreviousAccessor() {
        if (this._accessorStack.isEmpty()) {
            return null;
        }
        if (this._accessorStack.size() > 1) {
            return (Class)this._accessorStack.get(this._accessorStack.size() - 2);
        }
        return null;
    }

    public Class getFirstAccessor() {
        if (this._accessorStack.isEmpty()) {
            return null;
        }
        return (Class)this._accessorStack.get(0);
    }

    public Class getCurrentType() {
        if (this._typeStack.isEmpty()) {
            return null;
        }
        return (Class)this._typeStack.get(this._typeStack.size() - 1);
    }

    public void setCurrentType(Class type) {
        this._typeStack.add(type);
    }

    public Class getPreviousType() {
        if (this._typeStack.isEmpty()) {
            return null;
        }
        if (this._typeStack.size() > 1) {
            return (Class)this._typeStack.get(this._typeStack.size() - 2);
        }
        return null;
    }

    public void setPreviousType(Class type) {
        if (this._typeStack.isEmpty() || this._typeStack.size() < 2) {
            return;
        }
        this._typeStack.set(this._typeStack.size() - 2, type);
    }

    public Class getFirstType() {
        if (this._typeStack.isEmpty()) {
            return null;
        }
        return (Class)this._typeStack.get(0);
    }

    public void setCurrentNode(Node value) {
        this._currentNode = value;
    }

    public Node getCurrentNode() {
        return this._currentNode;
    }

    public Evaluation getCurrentEvaluation() {
        return this._currentEvaluation;
    }

    public void setCurrentEvaluation(Evaluation value) {
        this._currentEvaluation = value;
    }

    public Evaluation getRootEvaluation() {
        return this._rootEvaluation;
    }

    public void setRootEvaluation(Evaluation value) {
        this._rootEvaluation = value;
    }

    public Evaluation getEvaluation(int relativeIndex) {
        Evaluation result = null;
        if (relativeIndex <= 0) {
            for (result = this._currentEvaluation; ++relativeIndex < 0 && result != null; result = result.getParent()) {
            }
        }
        return result;
    }

    public void pushEvaluation(Evaluation value) {
        if (this._currentEvaluation != null) {
            this._currentEvaluation.addChild(value);
        } else {
            this.setRootEvaluation(value);
        }
        this.setCurrentEvaluation(value);
    }

    public Evaluation popEvaluation() {
        Evaluation result = this._currentEvaluation;
        this.setCurrentEvaluation(result.getParent());
        if (this._currentEvaluation == null) {
            this.setLastEvaluation(this.getKeepLastEvaluation() ? result : null);
            this.setRootEvaluation(null);
            this.setCurrentNode(null);
        }
        return result;
    }

    public int incrementLocalReferenceCounter() {
        return ++this._localReferenceCounter;
    }

    public void addLocalReference(String key, LocalReference reference) {
        if (this._localReferenceMap == null) {
            this._localReferenceMap = new LinkedHashMap();
        }
        this._localReferenceMap.put(key, reference);
    }

    public Map getLocalReferences() {
        return this._localReferenceMap;
    }

    public int size() {
        return this._values.size();
    }

    public boolean isEmpty() {
        return this._values.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this._values.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this._values.containsValue(value);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(Object key) {
        void var2_12;
        if (RESERVED_KEYS.containsKey(key)) {
            if (key.equals(THIS_CONTEXT_KEY)) {
                Object object = this.getCurrentObject();
                return var2_12;
            } else if (key.equals(ROOT_CONTEXT_KEY)) {
                Object object = this.getRoot();
                return var2_12;
            } else if (key.equals(CONTEXT_CONTEXT_KEY)) {
                OgnlContext ognlContext = this;
                return var2_12;
            } else if (key.equals(TRACE_EVALUATIONS_CONTEXT_KEY)) {
                Boolean bl = this.getTraceEvaluations() ? Boolean.TRUE : Boolean.FALSE;
                return var2_12;
            } else if (key.equals(LAST_EVALUATION_CONTEXT_KEY)) {
                Evaluation evaluation = this.getLastEvaluation();
                return var2_12;
            } else if (key.equals(KEEP_LAST_EVALUATION_CONTEXT_KEY)) {
                Boolean bl = this.getKeepLastEvaluation() ? Boolean.TRUE : Boolean.FALSE;
                return var2_12;
            } else if (key.equals(CLASS_RESOLVER_CONTEXT_KEY)) {
                ClassResolver classResolver = this.getClassResolver();
                return var2_12;
            } else if (key.equals(TYPE_CONVERTER_CONTEXT_KEY)) {
                TypeConverter typeConverter = this.getTypeConverter();
                return var2_12;
            } else {
                if (!key.equals(MEMBER_ACCESS_CONTEXT_KEY)) throw new IllegalArgumentException("unknown reserved key '" + key + "'");
                MemberAccess memberAccess = this.getMemberAccess();
            }
            return var2_12;
        } else {
            Object v = this._values.get(key);
        }
        return var2_12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object key, Object value) {
        Object result;
        if (!RESERVED_KEYS.containsKey(key)) return this._values.put(key, value);
        if (key.equals(THIS_CONTEXT_KEY)) {
            result = this.getCurrentObject();
            this.setCurrentObject(value);
            return result;
        } else if (key.equals(ROOT_CONTEXT_KEY)) {
            result = this.getRoot();
            this.setRoot(value);
            return result;
        } else {
            if (key.equals(CONTEXT_CONTEXT_KEY)) {
                throw new IllegalArgumentException("can't change context in context");
            }
            if (key.equals(TRACE_EVALUATIONS_CONTEXT_KEY)) {
                result = this.getTraceEvaluations() ? Boolean.TRUE : Boolean.FALSE;
                this.setTraceEvaluations(OgnlOps.booleanValue(value));
                return result;
            } else if (key.equals(LAST_EVALUATION_CONTEXT_KEY)) {
                result = this.getLastEvaluation();
                this._lastEvaluation = (Evaluation)value;
                return result;
            } else if (key.equals(KEEP_LAST_EVALUATION_CONTEXT_KEY)) {
                result = this.getKeepLastEvaluation() ? Boolean.TRUE : Boolean.FALSE;
                this.setKeepLastEvaluation(OgnlOps.booleanValue(value));
                return result;
            } else if (key.equals(CLASS_RESOLVER_CONTEXT_KEY)) {
                result = this.getClassResolver();
                this.setClassResolver((ClassResolver)value);
                return result;
            } else if (key.equals(TYPE_CONVERTER_CONTEXT_KEY)) {
                result = this.getTypeConverter();
                this.setTypeConverter((TypeConverter)value);
                return result;
            } else {
                if (!key.equals(MEMBER_ACCESS_CONTEXT_KEY)) throw new IllegalArgumentException("unknown reserved key '" + key + "'");
                result = this.getMemberAccess();
                this.setMemberAccess((MemberAccess)value);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object remove(Object key) {
        void var2_9;
        if (RESERVED_KEYS.containsKey(key)) {
            if (key.equals(THIS_CONTEXT_KEY)) {
                Object object = this.getCurrentObject();
                this.setCurrentObject(null);
                return var2_9;
            } else if (key.equals(ROOT_CONTEXT_KEY)) {
                Object object = this.getRoot();
                this.setRoot(null);
                return var2_9;
            } else {
                if (key.equals(CONTEXT_CONTEXT_KEY)) {
                    throw new IllegalArgumentException("can't remove context from context");
                }
                if (key.equals(TRACE_EVALUATIONS_CONTEXT_KEY)) {
                    throw new IllegalArgumentException("can't remove _traceEvaluations from context");
                }
                if (key.equals(LAST_EVALUATION_CONTEXT_KEY)) {
                    Evaluation evaluation = this._lastEvaluation;
                    this.setLastEvaluation(null);
                    return var2_9;
                } else {
                    if (key.equals(KEEP_LAST_EVALUATION_CONTEXT_KEY)) {
                        throw new IllegalArgumentException("can't remove _keepLastEvaluation from context");
                    }
                    if (key.equals(CLASS_RESOLVER_CONTEXT_KEY)) {
                        ClassResolver classResolver = this.getClassResolver();
                        this.setClassResolver(null);
                        return var2_9;
                    } else if (key.equals(TYPE_CONVERTER_CONTEXT_KEY)) {
                        TypeConverter typeConverter = this.getTypeConverter();
                        this.setTypeConverter(null);
                        return var2_9;
                    } else {
                        if (!key.equals(MEMBER_ACCESS_CONTEXT_KEY)) throw new IllegalArgumentException("unknown reserved key '" + key + "'");
                        MemberAccess memberAccess = this.getMemberAccess();
                        this.setMemberAccess(null);
                    }
                }
            }
            return var2_9;
        } else {
            Object v = this._values.remove(key);
        }
        return var2_9;
    }

    public void putAll(Map t) {
        for (Object k : t.keySet()) {
            this.put(k, t.get(k));
        }
    }

    public void clear() {
        this._values.clear();
        this._typeStack.clear();
        this._accessorStack.clear();
        this._localReferenceCounter = 0;
        if (this._localReferenceMap != null) {
            this._localReferenceMap.clear();
        }
        this.setRoot(null);
        this.setCurrentObject(null);
        this.setRootEvaluation(null);
        this.setCurrentEvaluation(null);
        this.setLastEvaluation(null);
        this.setCurrentNode(null);
        this.setClassResolver(DEFAULT_CLASS_RESOLVER);
        this.setTypeConverter(DEFAULT_TYPE_CONVERTER);
        this.setMemberAccess(DEFAULT_MEMBER_ACCESS);
    }

    public Set keySet() {
        return this._values.keySet();
    }

    public Collection values() {
        return this._values.values();
    }

    public Set entrySet() {
        return this._values.entrySet();
    }

    public boolean equals(Object o) {
        return this._values.equals(o);
    }

    public int hashCode() {
        return this._values.hashCode();
    }

    static {
        RESERVED_KEYS.put(CONTEXT_CONTEXT_KEY, null);
        RESERVED_KEYS.put(ROOT_CONTEXT_KEY, null);
        RESERVED_KEYS.put(THIS_CONTEXT_KEY, null);
        RESERVED_KEYS.put(TRACE_EVALUATIONS_CONTEXT_KEY, null);
        RESERVED_KEYS.put(LAST_EVALUATION_CONTEXT_KEY, null);
        RESERVED_KEYS.put(KEEP_LAST_EVALUATION_CONTEXT_KEY, null);
        RESERVED_KEYS.put(CLASS_RESOLVER_CONTEXT_KEY, null);
        RESERVED_KEYS.put(TYPE_CONVERTER_CONTEXT_KEY, null);
        RESERVED_KEYS.put(MEMBER_ACCESS_CONTEXT_KEY, null);
        try {
            String s = System.getProperty("ognl.traceEvaluations");
            if (s != null) {
                DEFAULT_TRACE_EVALUATIONS = Boolean.valueOf(s.trim());
            }
            if ((s = System.getProperty("ognl.keepLastEvaluation")) != null) {
                DEFAULT_KEEP_LAST_EVALUATION = Boolean.valueOf(s.trim());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

