/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RuntimeExtension.class}, property={"org.apache.sling.scripting.sightly.extension.name=uriManipulation"})
public class URIManipulationFilterExtension
implements RuntimeExtension {
    public static final String SCHEME = "scheme";
    public static final String DOMAIN = "domain";
    public static final String PATH = "path";
    public static final String APPEND_PATH = "appendPath";
    public static final String PREPEND_PATH = "prependPath";
    public static final String SELECTORS = "selectors";
    public static final String ADD_SELECTORS = "addSelectors";
    public static final String REMOVE_SELECTORS = "removeSelectors";
    public static final String EXTENSION = "extension";
    public static final String SUFFIX = "suffix";
    public static final String PREPEND_SUFFIX = "prependSuffix";
    public static final String APPEND_SUFFIX = "appendSuffix";
    public static final String FRAGMENT = "fragment";
    public static final String QUERY = "query";
    public static final String ADD_QUERY = "addQuery";
    public static final String REMOVE_QUERY = "removeQuery";
    private static final Logger LOG = LoggerFactory.getLogger(URIManipulationFilterExtension.class);

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("uriManipulation", arguments, 2);
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        String uriString = runtimeObjectModel.toString(arguments[0]);
        Map options = runtimeObjectModel.toMap(arguments[1]);
        try {
            URI originalUri = new URI(uriString);
            String scheme = this.getOption(SCHEME, options, originalUri.getScheme(), true);
            String fragment = this.getOption(FRAGMENT, options, originalUri.getFragment(), false);
            if (originalUri.isOpaque()) {
                URI transformedUri = new URI(scheme, originalUri.getSchemeSpecificPart(), fragment);
                return transformedUri.toString();
            }
            try {
                originalUri = originalUri.parseServerAuthority();
            }
            catch (URISyntaxException e) {
                LOG.warn("Only server-based authorities are supported for non-opaque URLs");
                throw e;
            }
            String host = this.getOption(DOMAIN, options, originalUri.getHost(), true);
            String path = this.getPath(runtimeObjectModel, originalUri.getPath(), options, scheme != null || host != null);
            String escapedQuery = this.getEscapedQuery(runtimeObjectModel, originalUri.getRawQuery(), options);
            URI transformedUri = new URI(scheme, originalUri.getUserInfo(), host, originalUri.getPort(), path, escapedQuery, fragment);
            return URIManipulationFilterExtension.unescapePercentInQuery(transformedUri.toString());
        }
        catch (URISyntaxException e) {
            LOG.warn("Cannot manipulate invalid URI '{}'", (Object)uriString, (Object)e);
            return uriString;
        }
    }

    static String unescapePercentInQuery(String uri) {
        String suffix;
        String query;
        String[] parts = uri.split("\\?", 2);
        if (parts.length != 2) {
            return uri;
        }
        String[] suffixParts = parts[1].split("#", 2);
        if (suffixParts.length == 2) {
            query = suffixParts[0];
            suffix = "#" + suffixParts[1];
        } else {
            query = parts[1];
            suffix = "";
        }
        return parts[0] + "?" + query.replaceAll("%25", "%") + suffix;
    }

    private String getOption(String key, Map<String, Object> options, String defaultValue, boolean useDefaultIfEmpty) {
        String value = (String)options.get(key);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        if (options.containsKey(key)) {
            if (useDefaultIfEmpty) {
                return defaultValue;
            }
            return null;
        }
        return defaultValue;
    }

    static String concatenateWithSlashes(String ... pathParts) {
        StringBuilder sb = new StringBuilder();
        for (String pathPart : pathParts) {
            if (!StringUtils.isNotBlank((CharSequence)pathPart)) continue;
            if (sb.length() > 0 && !pathPart.startsWith("/") && !sb.toString().endsWith("/")) {
                sb.append("/");
            }
            if (sb.toString().endsWith("/") && pathPart.startsWith("/")) {
                sb.append(pathPart.substring(1));
                continue;
            }
            sb.append(pathPart);
        }
        return sb.toString();
    }

    private String getPath(RuntimeObjectModel runtimeObjectModel, String originalPath, Map<String, Object> options, boolean isAbsolute) {
        ModifiableRequestPathInfo requestPathInfo = new ModifiableRequestPathInfo(originalPath);
        String prependPath = this.getOption(PREPEND_PATH, options, "", true);
        String path = this.getOption(PATH, options, requestPathInfo.getResourcePath(), true);
        String appendPath = this.getOption(APPEND_PATH, options, "", true);
        if (!options.containsKey(PATH) && StringUtils.isEmpty((CharSequence)path)) {
            LOG.debug("Do not modify path because original path was empty and not set through an option either!");
            return requestPathInfo.toString();
        }
        String newPath = URIManipulationFilterExtension.concatenateWithSlashes(prependPath, path, appendPath);
        if (isAbsolute && !newPath.startsWith("/")) {
            newPath = '/' + newPath;
        }
        requestPathInfo.setResourcePath(newPath);
        this.handleSelectors(runtimeObjectModel, requestPathInfo, options);
        String extension = this.getOption(EXTENSION, options, requestPathInfo.getExtension(), false);
        requestPathInfo.setExtension(extension);
        String prependSuffix = this.getOption(PREPEND_SUFFIX, options, "", true);
        String suffix = this.getOption(SUFFIX, options, requestPathInfo.getSuffix(), false);
        String appendSuffix = this.getOption(APPEND_SUFFIX, options, "", true);
        String newSuffix = URIManipulationFilterExtension.concatenateWithSlashes(prependSuffix, suffix, appendSuffix);
        if (StringUtils.isNotEmpty((CharSequence)newSuffix) && !newSuffix.startsWith("/")) {
            newSuffix = '/' + newSuffix;
        }
        requestPathInfo.setSuffix(newSuffix);
        return requestPathInfo.toString();
    }

    private String getEscapedQuery(RuntimeObjectModel runtimeObjectModel, String originalQuery, Map<String, Object> options) {
        LinkedHashMap<String, Collection<String>> parameters = new LinkedHashMap<String, Collection<String>>();
        if (StringUtils.isNotEmpty((CharSequence)originalQuery)) {
            String[] keyValuePairs = originalQuery.split("&");
            for (String keyValuePair : keyValuePairs) {
                String value;
                String param;
                String[] pair = keyValuePair.split("=");
                if (pair.length != 2) continue;
                try {
                    param = URLDecoder.decode(pair[0], StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Could not decode parameter key '{}'", (Object)pair[0], (Object)e);
                    continue;
                }
                try {
                    value = URLDecoder.decode(pair[1], StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Could not decode parameter value of parameter '{}': '{}'", new Object[]{param, pair[1], e});
                    continue;
                }
                ArrayList<String> values = (ArrayList<String>)parameters.get(param);
                if (values == null) {
                    values = new ArrayList<String>();
                    parameters.put(param, values);
                }
                values.add(value);
            }
        }
        if (this.handleParameters(runtimeObjectModel, parameters, options)) {
            if (!parameters.isEmpty()) {
                try {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry entry : parameters.entrySet()) {
                        for (String value : (Collection)entry.getValue()) {
                            sb.append(URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8.name())).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8.name())).append("&");
                        }
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    return sb.toString();
                }
                catch (UnsupportedEncodingException e) {
                    throw new SightlyException("Could not encode the parameter values/keys", (Throwable)e);
                }
            }
            return null;
        }
        return originalQuery;
    }

    private void handleSelectors(RuntimeObjectModel runtimeObjectModel, ModifiableRequestPathInfo requestPathInfo, Map<String, Object> options) {
        Object addSelectorsOption;
        int index;
        Object[] selectorsURIArray;
        String[] selectorsArray;
        String selectorString;
        if (options.containsKey(SELECTORS)) {
            Object selectorsOption = options.get(SELECTORS);
            if (selectorsOption == null) {
                requestPathInfo.clearSelectors();
            } else if (selectorsOption instanceof String) {
                selectorString = (String)selectorsOption;
                selectorsArray = selectorString.split("\\.");
                requestPathInfo.replaceSelectors(selectorsArray);
            } else if (selectorsOption instanceof Object[]) {
                selectorsURIArray = (Object[])selectorsOption;
                selectorsArray = new String[selectorsURIArray.length];
                index = 0;
                for (Object selector : selectorsURIArray) {
                    selectorsArray[index++] = runtimeObjectModel.toString(selector);
                }
                requestPathInfo.replaceSelectors(selectorsArray);
            }
        }
        if ((addSelectorsOption = options.get(ADD_SELECTORS)) instanceof String) {
            selectorString = (String)addSelectorsOption;
            selectorsArray = selectorString.split("\\.");
            requestPathInfo.addSelectors(selectorsArray);
        } else if (addSelectorsOption instanceof Object[]) {
            selectorsURIArray = (Object[])addSelectorsOption;
            selectorsArray = new String[selectorsURIArray.length];
            index = 0;
            for (Object selector : selectorsURIArray) {
                selectorsArray[index++] = runtimeObjectModel.toString(selector);
            }
            requestPathInfo.addSelectors(selectorsArray);
        }
        Object removeSelectorsOption = options.get(REMOVE_SELECTORS);
        if (removeSelectorsOption instanceof String) {
            String selectorString2 = (String)removeSelectorsOption;
            String[] selectorsArray2 = selectorString2.split("\\.");
            requestPathInfo.removeSelectors(selectorsArray2);
        } else if (removeSelectorsOption instanceof Object[]) {
            Object[] selectorsURIArray2 = (Object[])removeSelectorsOption;
            String[] selectorsArray3 = new String[selectorsURIArray2.length];
            int index2 = 0;
            for (Object selector : selectorsURIArray2) {
                selectorsArray3[index2++] = runtimeObjectModel.toString(selector);
            }
            requestPathInfo.removeSelectors(selectorsArray3);
        }
    }

    private boolean handleParameters(RuntimeObjectModel runtimeObjectModel, Map<String, Collection<String>> parameters, Map<String, Object> options) {
        Object removeQueryOption;
        Object addQueryOption;
        boolean hasModifiedParameters = false;
        if (options.containsKey(QUERY)) {
            Object queryOption = options.get(QUERY);
            parameters.clear();
            Map queryParameters = runtimeObjectModel.toMap(queryOption);
            this.addQueryParameters(runtimeObjectModel, parameters, queryParameters);
            hasModifiedParameters = true;
        }
        if ((addQueryOption = options.get(ADD_QUERY)) != null) {
            Map addParams = runtimeObjectModel.toMap(addQueryOption);
            this.addQueryParameters(runtimeObjectModel, parameters, addParams);
            hasModifiedParameters = true;
        }
        if ((removeQueryOption = options.get(REMOVE_QUERY)) != null) {
            if (removeQueryOption instanceof String) {
                parameters.remove(removeQueryOption);
            } else if (removeQueryOption instanceof Object[]) {
                Object[] removeQueryParamArray;
                for (Object param : removeQueryParamArray = (Object[])removeQueryOption) {
                    String paramString = runtimeObjectModel.toString(param);
                    if (paramString == null) continue;
                    parameters.remove(paramString);
                }
            }
            hasModifiedParameters = true;
        }
        return hasModifiedParameters;
    }

    private void addQueryParameters(RuntimeObjectModel runtimeObjectModel, Map<String, Collection<String>> parameters, Map<String, Object> queryParameters) {
        for (Map.Entry<String, Object> entry : queryParameters.entrySet()) {
            Object entryValue = entry.getValue();
            if (runtimeObjectModel.isCollection(entryValue)) {
                Collection collection = runtimeObjectModel.toCollection(entryValue);
                ArrayList<String> values = new ArrayList<String>(collection.size());
                for (Object o : collection) {
                    values.add(runtimeObjectModel.toString(o));
                }
                parameters.put(entry.getKey(), values);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>(1);
            values.add(runtimeObjectModel.toString(entryValue));
            parameters.put(entry.getKey(), values);
        }
    }

    static class ModifiableRequestPathInfo
    implements RequestPathInfo {
        private String resourcePath;
        private List<String> selectors;
        private String extension;
        private String suffix;

        ModifiableRequestPathInfo(String path) {
            String pathToSplit;
            String pathToParse;
            if (path == null) {
                throw new NullPointerException("The path parameter cannot be null.");
            }
            this.selectors = new LinkedList<String>();
            int firstDot = path.indexOf(46);
            if (firstDot >= 0) {
                pathToParse = path.substring(firstDot);
                this.resourcePath = path.substring(0, firstDot);
            } else {
                pathToParse = "";
                this.resourcePath = path;
            }
            int firstSlash = pathToParse.indexOf(47);
            if (firstSlash < 0) {
                pathToSplit = pathToParse;
                this.suffix = null;
            } else {
                pathToSplit = pathToParse.substring(0, firstSlash);
                this.suffix = pathToParse.substring(firstSlash);
            }
            int lastDot = pathToSplit.lastIndexOf(46);
            if (lastDot > 1) {
                String tmpSel = pathToSplit.substring(1, lastDot);
                this.selectors.addAll(Arrays.asList(tmpSel.split("\\.")));
            }
            this.extension = lastDot + 1 < pathToSplit.length() ? pathToSplit.substring(lastDot + 1) : null;
        }

        void setExtension(String extension) {
            this.extension = extension;
        }

        void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @NotNull
        public String getResourcePath() {
            return this.resourcePath;
        }

        void setResourcePath(String path) {
            this.resourcePath = path;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getSelectorString() {
            throw new UnsupportedOperationException();
        }

        public String getSuffix() {
            return this.suffix;
        }

        @NotNull
        public String[] getSelectors() {
            return this.selectors.toArray(new String[0]);
        }

        public Resource getSuffixResource() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getResourcePath());
            if (this.getSelectors().length > 0) {
                for (String selector : this.selectors) {
                    if (!StringUtils.isNotBlank((CharSequence)selector) || selector.contains(" ")) continue;
                    sb.append(".").append(selector);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)this.getExtension())) {
                sb.append('.').append(this.getExtension());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.getSuffix())) {
                sb.append(this.getSuffix());
            }
            return sb.toString();
        }

        void replaceSelectors(String[] selectorsArray) {
            this.selectors.clear();
            this.selectors.addAll(Arrays.asList(selectorsArray));
        }

        void addSelectors(String[] selectorsArray) {
            this.selectors.addAll(Arrays.asList(selectorsArray));
        }

        void removeSelectors(String[] selectorsArray) {
            this.selectors.removeAll(Arrays.asList(selectorsArray));
        }

        void clearSelectors() {
            this.selectors.clear();
        }
    }
}

