/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.scripting.sightly.impl.engine.ResourceBackedPojoChangeMonitor;
import org.apache.sling.scripting.sightly.impl.engine.SightlyJavaCompilerService;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.pojo.Use;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UseProvider.class}, configurationPid={"org.apache.sling.scripting.sightly.impl.engine.extension.use.JavaUseProvider"}, property={"service.ranking:Integer=90"})
@Designate(ocd=Configuration.class)
public class JavaUseProvider
implements UseProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JavaUseProvider.class);
    private static final Pattern JAVA_PATTERN = Pattern.compile("([[\\p{L}&&[^\\p{Lu}]]_$][\\p{L}\\p{N}_$]*\\.)*[\\p{Lu}_$][\\p{L}\\p{N}_$]*");
    @Reference
    private SightlyJavaCompilerService sightlyJavaCompilerService = null;
    @Reference
    private ResourceBackedPojoChangeMonitor resourceBackedPojoChangeMonitor = null;
    @Reference
    private ClassLoaderWriter classLoaderWriter = null;
    private static final Object NULL = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments) {
        ProviderOutcome providerOutcome;
        Object result;
        if (!JAVA_PATTERN.matcher(identifier).matches()) {
            LOG.debug("Identifier {} does not match a Java class name pattern.", (Object)identifier);
            return ProviderOutcome.failure();
        }
        Bindings globalBindings = renderContext.getBindings();
        SlingScriptHelper sling = BindingsUtils.getHelper(globalBindings);
        SlingHttpServletRequest request = BindingsUtils.getRequest(globalBindings);
        Map<String, Object> overrides = this.setRequestAttributes((ServletRequest)request, arguments);
        try {
            LOG.debug("Attempting to load class {} from the classloader cache.", (Object)identifier);
            Class<?> cls = this.classLoaderWriter.getClassLoader().loadClass(identifier);
            if (this.resourceBackedPojoChangeMonitor.getLastModifiedDateForJavaUseObject(identifier) > 0L) {
                LOG.debug("Class {} is available in the classloader cache but it needs to be recompiled.", (Object)identifier);
                Object result2 = this.sightlyJavaCompilerService.getInstance(renderContext, identifier);
                if (result2 instanceof Use) {
                    ((Use)result2).init(BindingsUtils.merge(globalBindings, arguments));
                }
                ProviderOutcome providerOutcome2 = ProviderOutcome.success((Object)result2);
                return providerOutcome2;
            }
            result = sling.getService(cls);
            if (result != null) {
                ProviderOutcome providerOutcome3 = ProviderOutcome.success((Object)result);
                return providerOutcome3;
            }
            result = request.adaptTo(cls);
            if (result == null) {
                Resource resource = BindingsUtils.getResource(globalBindings);
                result = resource.adaptTo(cls);
            }
            if (result != null) {
                providerOutcome = ProviderOutcome.success((Object)result);
                return providerOutcome;
            }
            result = cls.newInstance();
            if (result instanceof Use) {
                ((Use)result).init(BindingsUtils.merge(globalBindings, arguments));
            }
            providerOutcome = ProviderOutcome.notNullOrFailure((Object)result);
            return providerOutcome;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Class {} was not found in the classloader cache.", (Object)identifier);
            result = this.sightlyJavaCompilerService.getInstance(renderContext, identifier);
            if (result instanceof Use) {
                ((Use)result).init(BindingsUtils.merge(globalBindings, arguments));
            }
            providerOutcome = ProviderOutcome.success((Object)result);
            return providerOutcome;
        }
        catch (Exception e) {
            providerOutcome = ProviderOutcome.failure((Throwable)e);
            return providerOutcome;
        }
        finally {
            this.resetRequestAttribute((ServletRequest)request, overrides);
        }
    }

    private Map<String, Object> setRequestAttributes(ServletRequest request, Bindings arguments) {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        for (Map.Entry entry : arguments.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Object oldValue = request.getAttribute(key);
            if (oldValue != null) {
                overrides.put(key, oldValue);
            } else {
                overrides.put(key, NULL);
            }
            request.setAttribute(key, value);
        }
        return overrides;
    }

    private void resetRequestAttribute(ServletRequest request, Map<String, Object> overrides) {
        for (Map.Entry<String, Object> entry : overrides.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == NULL) {
                request.removeAttribute(key);
                continue;
            }
            request.setAttribute(key, value);
        }
    }

    @ObjectClassDefinition(name="Apache Sling Scripting HTL Java Use Provider Configuration", description="HTL Java Use Provider configuration options")
    static @interface Configuration {
        @AttributeDefinition(name="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.")
        public int service_ranking() default 90;
    }
}

