/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.script.Bindings;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.impl.engine.extension.PrintWriterResponseWrapper;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RuntimeExtension.class}, property={"org.apache.sling.scripting.sightly.extension.name=include"})
public class IncludeRuntimeExtension
implements RuntimeExtension {
    private static final Logger LOG = LoggerFactory.getLogger(IncludeRuntimeExtension.class);
    private static final String OPTION_FILE = "file";
    private static final String OPTION_PREPEND_PATH = "prependPath";
    private static final String OPTION_APPEND_PATH = "appendPath";
    private static final String OPTION_REQUEST_ATTRIBUTES = "requestAttributes";

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("include", arguments, 2);
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        String originalPath = runtimeObjectModel.toString(arguments[0]);
        Map options = (Map)arguments[1];
        String path = this.buildPath(originalPath, options);
        StringWriter output = new StringWriter();
        Bindings bindings = renderContext.getBindings();
        SlingHttpServletRequest request = BindingsUtils.getRequest(bindings);
        Map<String, Object> originalAttributes = ExtensionUtils.setRequestAttributes(request, (Map)options.remove(OPTION_REQUEST_ATTRIBUTES));
        this.includeScript(bindings, path, new PrintWriter(output));
        ExtensionUtils.setRequestAttributes(request, originalAttributes);
        return output.toString();
    }

    private String buildPath(String path, Map options) {
        if (StringUtils.isEmpty((String)path)) {
            path = (String)options.get(OPTION_FILE);
        }
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        String prependPath = (String)options.get(OPTION_PREPEND_PATH);
        String appendPath = (String)options.get(OPTION_APPEND_PATH);
        if (StringUtils.isNotEmpty((String)prependPath)) {
            path = prependPath + path;
        }
        if (StringUtils.isNotEmpty((String)appendPath)) {
            path = path + appendPath;
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void includeScript(Bindings bindings, String script, PrintWriter out) {
        if (StringUtils.isEmpty((String)script)) {
            throw new SightlyException("Path for data-sly-include is empty");
        }
        LOG.debug("Attempting to include script {}.", (Object)script);
        SlingScriptHelper slingScriptHelper = BindingsUtils.getHelper(bindings);
        ServletResolver servletResolver = (ServletResolver)slingScriptHelper.getService(ServletResolver.class);
        if (servletResolver == null) throw new SightlyException("Sling ServletResolver service is unavailable, failed to include " + script);
        SlingHttpServletRequest request = BindingsUtils.getRequest(bindings);
        Servlet servlet = servletResolver.resolveServlet(request.getResource(), script);
        if (servlet == null) throw new SightlyException("Failed to locate script " + script);
        try {
            SlingHttpServletResponse response = BindingsUtils.getResponse(bindings);
            PrintWriterResponseWrapper resWrapper = new PrintWriterResponseWrapper(out, response);
            servlet.service((ServletRequest)request, (ServletResponse)resWrapper);
            return;
        }
        catch (Exception e) {
            throw new SightlyException("Failed to include script " + script, e);
        }
    }
}

