/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.osgi.service.component.annotations.Component;

@Component(service={RuntimeExtension.class}, property={"org.apache.sling.scripting.sightly.extension.name=format"})
public class FormatFilterExtension
implements RuntimeExtension {
    private static final Pattern PLACEHOLDER_REGEX = Pattern.compile("\\{\\d+}");

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("format", arguments, 2);
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        String source = runtimeObjectModel.toString(arguments[0]);
        Object[] params = this.decodeParams(runtimeObjectModel, arguments[1]);
        return this.replace(runtimeObjectModel, source, params);
    }

    private Object[] decodeParams(RuntimeObjectModel runtimeObjectModel, Object paramObj) {
        if (runtimeObjectModel.isCollection(paramObj)) {
            return runtimeObjectModel.toCollection(paramObj).toArray();
        }
        return new Object[]{paramObj};
    }

    private String replace(RuntimeObjectModel runtimeObjectModel, String source, Object[] params) {
        Matcher matcher = PLACEHOLDER_REGEX.matcher(source);
        StringBuilder builder = new StringBuilder();
        int lastPos = 0;
        boolean matched = true;
        while (matched) {
            matched = matcher.find();
            if (!matched) continue;
            String group = matcher.group();
            int paramIndex = Integer.parseInt(group.substring(1, group.length() - 1));
            String replacement = this.param(runtimeObjectModel, params, paramIndex);
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            builder.append(source, lastPos, matchStart).append(replacement);
            lastPos = matchEnd;
        }
        builder.append(source, lastPos, source.length());
        return builder.toString();
    }

    private String param(RuntimeObjectModel runtimeObjectModel, Object[] params, int index) {
        if (index >= 0 && index < params.length) {
            return runtimeObjectModel.toString(params[index]);
        }
        return "";
    }
}

