/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.compiled;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.java.compiler.ClassInfo;
import org.apache.sling.scripting.sightly.java.compiler.JavaEscapeUtils;

public class SourceIdentifier
implements ClassInfo {
    public static final Pattern MANGLED_CHAR_PATTERN = Pattern.compile("(.*)(__[0-9a-f]{4}__)(.*)");
    private SightlyEngineConfiguration engineConfiguration;
    private String scriptName;
    private String simpleClassName;
    private String packageName;
    private String fullyQualifiedClassName;

    public SourceIdentifier(SightlyEngineConfiguration engineConfiguration, String scriptName) {
        this.engineConfiguration = engineConfiguration;
        this.scriptName = scriptName;
    }

    public String getSimpleClassName() {
        if (this.simpleClassName == null) {
            int lastSlashIndex = this.scriptName.lastIndexOf("/");
            String processingScriptName = this.scriptName;
            if (this.scriptName.endsWith(".java")) {
                processingScriptName = this.scriptName.substring(0, this.scriptName.length() - 5);
            }
            this.simpleClassName = lastSlashIndex != -1 ? JavaEscapeUtils.makeJavaPackage((String)processingScriptName.substring(lastSlashIndex)) : JavaEscapeUtils.makeJavaPackage((String)processingScriptName);
        }
        return this.simpleClassName;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            int lastSlashIndex = this.scriptName.lastIndexOf("/");
            String processingScriptName = this.scriptName;
            boolean javaFile = this.scriptName.endsWith(".java");
            if (javaFile) {
                processingScriptName = this.scriptName.substring(0, this.scriptName.length() - 5).replaceAll("-", "_");
            }
            this.packageName = lastSlashIndex != -1 ? JavaEscapeUtils.makeJavaPackage((String)processingScriptName.substring(0, lastSlashIndex)) : JavaEscapeUtils.makeJavaPackage((String)processingScriptName);
            if (!javaFile) {
                this.packageName = this.engineConfiguration.getBundleSymbolicName() + "." + this.packageName;
            }
        }
        return this.packageName;
    }

    public String getFullyQualifiedClassName() {
        if (this.fullyQualifiedClassName == null) {
            this.fullyQualifiedClassName = this.getPackageName() + "." + this.getSimpleClassName();
        }
        return this.fullyQualifiedClassName;
    }

    public static Resource getPOJOFromFQCN(ResourceResolver resolver, String slashSubpackage, String fullyQualifiedClassName) {
        String className = fullyQualifiedClassName;
        StringBuilder pathElements = new StringBuilder("/");
        if (StringUtils.isNotEmpty((String)slashSubpackage) && className.contains(slashSubpackage)) {
            className = className.replaceAll(slashSubpackage + "\\.", "");
        }
        String[] classElements = StringUtils.split((String)className, (char)'.');
        for (int i = 0; i < classElements.length; ++i) {
            String classElem = classElements[i];
            Matcher matcher = MANGLED_CHAR_PATTERN.matcher(classElem);
            if (matcher.matches()) {
                String group = matcher.group(2);
                char unmangled = JavaEscapeUtils.unmangle((String)group);
                classElem = classElem.replaceAll(group, Character.toString(unmangled));
                while (matcher.find()) {
                    group = matcher.group(2);
                    unmangled = JavaEscapeUtils.unmangle((String)group);
                    classElem = classElem.replaceAll(group, Character.toString(unmangled));
                }
            } else {
                int underscoreIndex = classElem.indexOf(95);
                if (underscoreIndex > -1) {
                    if (underscoreIndex == classElem.length() - 1) {
                        classElem = classElem.substring(0, classElem.length() - 1);
                    } else if (underscoreIndex == 0 && !Character.isJavaIdentifierStart(classElem.charAt(1))) {
                        classElem = classElem.substring(1);
                    }
                }
            }
            pathElements.append(classElem);
            if (i >= classElements.length - 1) continue;
            pathElements.append("/");
        }
        Set<String> possiblePOJOPaths = SourceIdentifier.getPossiblePojoPaths(pathElements.toString() + ".java");
        for (String possiblePath : possiblePOJOPaths) {
            Resource r = resolver.getResource(possiblePath);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static Set<String> getPossiblePojoPaths(String originalPath) {
        AmbiguousPathSymbol[] symbols;
        LinkedHashSet<String> possiblePaths = new LinkedHashSet<String>();
        possiblePaths.add(originalPath);
        HashMap<Integer, String> chars = new HashMap<Integer, String>();
        for (AmbiguousPathSymbol symbol : symbols = AmbiguousPathSymbol.values()) {
            String pathCopy = originalPath.substring(0, originalPath.lastIndexOf("/"));
            int actualIndex = 0;
            boolean firstPass = true;
            while (pathCopy.indexOf(symbol.getSymbol().charValue()) != -1) {
                int pos = pathCopy.indexOf(symbol.getSymbol().charValue());
                actualIndex += pos;
                if (!firstPass) {
                    ++actualIndex;
                }
                chars.put(actualIndex, symbol.getSymbol().toString());
                pathCopy = pathCopy.substring(pos + 1);
                firstPass = false;
            }
        }
        if (chars.size() > 0) {
            ArrayList<AmbiguousPathSymbol[]> possibleArrangements = new ArrayList<AmbiguousPathSymbol[]>();
            SourceIdentifier.populateArray(possibleArrangements, new AmbiguousPathSymbol[chars.size()], 0);
            Integer[] indexes = chars.keySet().toArray(new Integer[chars.size()]);
            for (AmbiguousPathSymbol[] arrangement : possibleArrangements) {
                char[] possiblePath = originalPath.toCharArray();
                for (int i = 0; i < arrangement.length; ++i) {
                    char currentSymbol = arrangement[i].getSymbol().charValue();
                    int currentIndex = indexes[i];
                    possiblePath[currentIndex] = currentSymbol;
                }
                possiblePaths.add(new String(possiblePath));
            }
        }
        return possiblePaths;
    }

    private static void populateArray(ArrayList<AmbiguousPathSymbol[]> arrayCollection, AmbiguousPathSymbol[] symbolsArrangementArray, int index) {
        if (symbolsArrangementArray.length > 0) {
            if (index == symbolsArrangementArray.length) {
                arrayCollection.add((AmbiguousPathSymbol[])symbolsArrangementArray.clone());
            } else {
                AmbiguousPathSymbol[] ambiguousPathSymbolArray = AmbiguousPathSymbol.values();
                int n = ambiguousPathSymbolArray.length;
                for (int i = 0; i < n; ++i) {
                    AmbiguousPathSymbol symbol;
                    symbolsArrangementArray[index] = symbol = ambiguousPathSymbolArray[i];
                    SourceIdentifier.populateArray(arrayCollection, symbolsArrangementArray, index + 1);
                }
            }
        }
    }

    static enum AmbiguousPathSymbol {
        DASH(Character.valueOf('-')),
        UNDERSCORE(Character.valueOf('_')),
        POINT(Character.valueOf('.'));

        private Character symbol;

        private AmbiguousPathSymbol(Character symbol) {
            this.symbol = symbol;
        }

        public Character getSymbol() {
            return this.symbol;
        }
    }
}

