/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilationUnit;
import org.apache.sling.commons.compiler.CompilerMessage;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.impl.engine.ResourceBackedPojoChangeMonitor;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SourceIdentifier;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SightlyJavaCompilerService.class})
public class SightlyJavaCompilerService {
    private static final Logger LOG = LoggerFactory.getLogger(SightlyJavaCompilerService.class);
    public static final Pattern PACKAGE_DECL_PATTERN = Pattern.compile("(\\s*)package\\s+([a-zA-Z_$][a-zA-Z\\d_$]*\\.?)+;");
    @Reference
    private ClassLoaderWriter classLoaderWriter = null;
    @Reference
    private JavaCompiler javaCompiler = null;
    @Reference
    private ResourceBackedPojoChangeMonitor resourceBackedPojoChangeMonitor = null;
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration = null;
    private Options options;

    public Object getInstance(RenderContext renderContext, String className) {
        RenderContextImpl rci = (RenderContextImpl)renderContext;
        LOG.debug("Attempting to load class {}.", (Object)className);
        if (className.contains(".")) {
            if (this.resourceBackedPojoChangeMonitor.getLastModifiedDateForJavaUseObject(className) > 0L) {
                LOG.debug("Class {} identifies a POJO from the repository that was changed since the last time it was instantiated.", (Object)className);
                Object result = this.compileRepositoryJavaClass(rci.getScriptResourceResolver(), className);
                this.resourceBackedPojoChangeMonitor.clearJavaUseObject(className);
                return result;
            }
            try {
                LOG.debug("Attempting to load class {} from the classloader cache.", (Object)className);
                return this.classLoaderWriter.getClassLoader().loadClass(className).newInstance();
            }
            catch (Exception e) {
                LOG.debug("Class {} identifies a POJO from the repository and it needs to be compiled.", (Object)className);
                return this.compileRepositoryJavaClass(rci.getScriptResourceResolver(), className);
            }
        }
        Resource pojoResource = rci.resolveScript(className + ".java");
        if (pojoResource != null) {
            SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, pojoResource.getPath());
            String fqcn = sourceIdentifier.getFullyQualifiedClassName();
            LOG.debug("Class {} has FQCN {}.", (Object)className, (Object)fqcn);
            return this.getInstance(renderContext, fqcn);
        }
        throw new SightlyException("Cannot find class " + className + ".");
    }

    public Object compileSource(SourceIdentifier sourceIdentifier, String sourceCode) {
        try {
            return this.internalCompileSource(sourceIdentifier, sourceCode);
        }
        catch (Exception e) {
            throw new SightlyException(e);
        }
    }

    private Object internalCompileSource(SourceIdentifier sourceIdentifier, String sourceCode) throws Exception {
        String fqcn = sourceIdentifier.getFullyQualifiedClassName();
        if (this.sightlyEngineConfiguration.keepGenerated()) {
            String path = "/" + fqcn.replaceAll("\\.", "/") + ".java";
            OutputStream os = this.classLoaderWriter.getOutputStream(path);
            IOUtils.write((String)sourceCode, (OutputStream)os, (String)"UTF-8");
            IOUtils.closeQuietly((OutputStream)os);
        }
        String[] sourceCodeLines = sourceCode.split("\\r\\n|[\\n\\x0B\\x0C\\r\\u0085\\u2028\\u2029]");
        boolean foundPackageDeclaration = false;
        for (String line : sourceCodeLines) {
            Matcher matcher = PACKAGE_DECL_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            foundPackageDeclaration = true;
            break;
        }
        if (!foundPackageDeclaration) {
            sourceCode = "package " + sourceIdentifier.getPackageName() + ";\n" + sourceCode;
        }
        SightlyCompilationUnit compilationUnit = new SightlyCompilationUnit(sourceCode, fqcn);
        long start = System.currentTimeMillis();
        CompilationResult compilationResult = this.javaCompiler.compile(new CompilationUnit[]{compilationUnit}, this.options);
        long end = System.currentTimeMillis();
        List errors = compilationResult.getErrors();
        if (errors != null && errors.size() > 0) {
            throw new SightlyException(this.createErrorMsg(errors));
        }
        if (compilationResult.didCompile()) {
            LOG.debug("Class {} was compiled in {}ms.", (Object)fqcn, (Object)(end - start));
        }
        return this.classLoaderWriter.getClassLoader().loadClass(fqcn).newInstance();
    }

    private Object compileRepositoryJavaClass(ResourceResolver resolver, String className) {
        Resource pojoResource = SourceIdentifier.getPOJOFromFQCN(resolver, this.sightlyEngineConfiguration.getBundleSymbolicName(), className);
        if (pojoResource != null) {
            try {
                SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, pojoResource.getPath());
                return this.compileSource(sourceIdentifier, IOUtils.toString((InputStream)((InputStream)pojoResource.adaptTo(InputStream.class)), (String)"UTF-8"));
            }
            catch (IOException e) {
                throw new SightlyException(String.format("Unable to compile class %s from %s.", className, pojoResource.getPath()), e);
            }
        }
        throw new SightlyException("Cannot find a file corresponding to class " + className + " in the repository.");
    }

    @Activate
    protected void activate() {
        LOG.info("Activating {}", (Object)this.getClass().getName());
        String version = System.getProperty("java.specification.version");
        this.options = new Options();
        this.options.put((Object)"generateDebugInfo", (Object)true);
        this.options.put((Object)"sourceVersion", (Object)version);
        this.options.put((Object)"targetVersion", (Object)version);
        this.options.put((Object)"classLoaderWriter", (Object)this.classLoaderWriter);
        this.options.put((Object)"forceCompilation", (Object)true);
    }

    private String createErrorMsg(List<CompilerMessage> errors) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Compilation errors in ");
        buffer.append(errors.get(0).getFile());
        buffer.append(":");
        StringBuilder errorsBuffer = new StringBuilder();
        boolean duplicateVariable = false;
        for (CompilerMessage e : errors) {
            if (!duplicateVariable && e.getMessage().contains("Duplicate local variable")) {
                duplicateVariable = true;
                buffer.append(" Maybe you defined more than one identical block elements without defining a different variable for each one?");
            }
            errorsBuffer.append("\nLine ");
            errorsBuffer.append(e.getLine());
            errorsBuffer.append(", column ");
            errorsBuffer.append(e.getColumn());
            errorsBuffer.append(" : ");
            errorsBuffer.append(e.getMessage());
        }
        buffer.append((CharSequence)errorsBuffer);
        return buffer.toString();
    }

    private static class SightlyCompilationUnit
    implements CompilationUnit {
        private String fqcn;
        private String sourceCode;

        SightlyCompilationUnit(String sourceCode, String fqcn) throws Exception {
            this.sourceCode = sourceCode;
            this.fqcn = fqcn;
        }

        public Reader getSource() throws IOException {
            return new InputStreamReader(IOUtils.toInputStream((String)this.sourceCode, (String)"UTF-8"), "UTF-8");
        }

        public String getMainClassName() {
            return this.fqcn;
        }

        public long getLastModified() {
            return System.currentTimeMillis();
        }
    }
}

