/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SourceIdentifier;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceBackedPojoChangeMonitor.class, ResourceChangeListener.class}, property={"resource.paths=glob:**/*.java", "resource.change.types=ADDED", "resource.change.types=CHANGED", "resource.change.types=REMOVED"})
public class ResourceBackedPojoChangeMonitor
implements ResourceChangeListener,
ExternalResourceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBackedPojoChangeMonitor.class);
    private Map<String, Long> slyJavaUseMap = new ConcurrentHashMap<String, Long>();
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration = null;

    public long getLastModifiedDateForJavaUseObject(String className) {
        if (className == null) {
            return 0L;
        }
        Long date = this.slyJavaUseMap.get(className);
        return date != null ? date : 0L;
    }

    public void clearJavaUseObject(String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            this.slyJavaUseMap.remove(className);
        }
    }

    public void onChange(@Nonnull List<ResourceChange> changes) {
        for (ResourceChange change : changes) {
            String path = change.getPath();
            ResourceChange.ChangeType changeType = change.getType();
            SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, path);
            switch (changeType) {
                case ADDED: 
                case CHANGED: {
                    this.slyJavaUseMap.put(sourceIdentifier.getFullyQualifiedClassName(), System.currentTimeMillis());
                    break;
                }
                case REMOVED: {
                    this.slyJavaUseMap.remove(sourceIdentifier.getFullyQualifiedClassName());
                    break;
                }
            }
            LOG.debug("Java Use Object {} was {}.", (Object)path, (Object)changeType.toString());
        }
    }
}

