/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp;

import java.io.Reader;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingServletException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.jsp.JspServletConfig;
import org.apache.sling.scripting.jsp.JspServletContext;
import org.apache.sling.scripting.jsp.JspServletOptions;
import org.apache.sling.scripting.jsp.SlingIOProvider;
import org.apache.sling.scripting.jsp.SlingPageException;
import org.apache.sling.scripting.jsp.SlingTldLocationsCache;
import org.apache.sling.scripting.jsp.jasper.Options;
import org.apache.sling.scripting.jsp.jasper.compiler.JspRuntimeContext;
import org.apache.sling.scripting.jsp.jasper.runtime.AnnotationProcessor;
import org.apache.sling.scripting.jsp.jasper.runtime.JspApplicationContextImpl;
import org.apache.sling.scripting.jsp.jasper.servlet.JspServletWrapper;
import org.apache.sling.scripting.jsp.util.TagUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%jsphandler.name", description="%jsphandler.description", metatype=true)
@Service(value={ScriptEngineFactory.class})
@Properties(value={@Property(name="service.description", value={"JSP Script Handler"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="jasper.classdebuginfo", boolValue={true}), @Property(name="jasper.enablePooling", boolValue={true}), @Property(name="jasper.ieClassId", value={"clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"}), @Property(name="jasper.genStringAsCharArray", boolValue={false}), @Property(name="jasper.keepgenerated", boolValue={true}), @Property(name="jasper.mappedfile", boolValue={true}), @Property(name="jasper.trimSpaces", boolValue={false}), @Property(name="jasper.displaySourceFragments", boolValue={false})})
public class JspScriptEngineFactory
extends AbstractScriptEngineFactory
implements EventHandler {
    @Property(boolValue={true})
    private static final String PROP_DEFAULT_IS_SESSION = "default.is.session";
    private final Logger logger = LoggerFactory.getLogger(JspScriptEngineFactory.class);
    @Reference(unbind="unbindSlingServletContext")
    private ServletContext slingServletContext;
    @Reference
    private ClassLoaderWriter classLoaderWriter;
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    private ClassLoader dynamicClassLoader;
    private SlingIOProvider ioProvider;
    private SlingTldLocationsCache tldLocationsCache;
    private JspRuntimeContext jspRuntimeContext;
    private Options options;
    private JspServletContext jspServletContext;
    private ServletConfig servletConfig;
    private ServiceRegistration eventHandlerRegistration;
    private boolean defaultIsSession;
    private JspRuntimeContext.JspFactoryHandler jspFactoryHandler;
    public static final String[] SCRIPT_TYPE = new String[]{"jsp", "jspf", "jspx"};
    public static final String[] NAMES = new String[]{"jsp", "JSP"};

    public JspScriptEngineFactory() {
        this.setExtensions(SCRIPT_TYPE);
        this.setNames(NAMES);
    }

    public ScriptEngine getScriptEngine() {
        return new JspScriptEngine();
    }

    public String getLanguageName() {
        return "Java Server Pages";
    }

    public String getLanguageVersion() {
        return "2.1";
    }

    public Object getParameter(String name) {
        if ("THREADING".equals(name)) {
            return "STATELESS";
        }
        return super.getParameter(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callErrorPageJsp(Bindings bindings, SlingScriptHelper scriptHelper, ScriptContext context, String scriptName) {
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        ResourceResolver resolver = (ResourceResolver)context.getAttribute("org.apache.sling.api.scripting.ScriptResourceResolver", -314);
        if (resolver == null) {
            resolver = scriptHelper.getScript().getScriptResource().getResourceResolver();
        }
        SlingIOProvider io = this.ioProvider;
        JspRuntimeContext.JspFactoryHandler jspfh = this.jspFactoryHandler;
        if (io == null || jspfh == null) {
            this.logger.warn("callJsp: JSP Script Engine seems to be shut down concurrently; not calling {}", (Object)scriptHelper.getScript().getScriptResource().getPath());
            return;
        }
        ResourceResolver oldResolver = io.setRequestResourceResolver(resolver);
        jspfh.incUsage();
        try {
            JspServletWrapper errorJsp = this.getJspWrapper(scriptName, slingBindings);
            errorJsp.service(slingBindings);
            SlingHttpServletRequest request = slingBindings.getRequest();
            Throwable t = (Throwable)request.getAttribute("javax.servlet.jsp.jspException");
            Object newException = request.getAttribute("javax.servlet.error.exception");
            if (newException != null && newException == t) {
                request.removeAttribute("javax.servlet.error.exception");
            }
            request.removeAttribute("javax.servlet.error.status_code");
            request.removeAttribute("javax.servlet.error.request_uri");
            request.removeAttribute("javax.servlet.error.status_code");
            request.removeAttribute("javax.servlet.jsp.jspException");
        }
        finally {
            jspfh.decUsage();
            io.resetRequestResourceResolver(oldResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callJsp(Bindings bindings, SlingScriptHelper scriptHelper, ScriptContext context) {
        ResourceResolver resolver = (ResourceResolver)context.getAttribute("org.apache.sling.api.scripting.ScriptResourceResolver", -314);
        if (resolver == null) {
            resolver = scriptHelper.getScript().getScriptResource().getResourceResolver();
        }
        SlingIOProvider io = this.ioProvider;
        JspRuntimeContext.JspFactoryHandler jspfh = this.jspFactoryHandler;
        if (io == null || jspfh == null) {
            this.logger.warn("callJsp: JSP Script Engine seems to be shut down concurrently; not calling {}", (Object)scriptHelper.getScript().getScriptResource().getPath());
            return;
        }
        ResourceResolver oldResolver = io.setRequestResourceResolver(resolver);
        jspfh.incUsage();
        try {
            SlingBindings slingBindings = new SlingBindings();
            slingBindings.putAll((Map)bindings);
            JspServletWrapper jsp = this.getJspWrapper(scriptHelper, slingBindings);
            jsp.service(slingBindings);
        }
        finally {
            jspfh.decUsage();
            io.resetRequestResourceResolver(oldResolver);
        }
    }

    private JspServletWrapper getJspWrapper(String scriptName, SlingBindings bindings) throws SlingException {
        JspRuntimeContext rctxt = this.getJspRuntimeContext();
        JspServletWrapper wrapper = rctxt.getWrapper(scriptName);
        if (wrapper != null) {
            if (wrapper.isValid()) {
                return wrapper;
            }
            rctxt.removeWrapper(wrapper.getJspUri());
            this.renewJspRuntimeContext();
            rctxt = this.getJspRuntimeContext();
        }
        wrapper = new JspServletWrapper(this.servletConfig, this.options, scriptName, false, rctxt, this.defaultIsSession);
        wrapper = rctxt.addWrapper(scriptName, wrapper);
        return wrapper;
    }

    private JspServletWrapper getJspWrapper(SlingScriptHelper scriptHelper, SlingBindings bindings) throws SlingException {
        SlingScript script = scriptHelper.getScript();
        String scriptName = script.getScriptResource().getPath();
        return this.getJspWrapper(scriptName, bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.defaultIsSession = PropertiesUtil.toBoolean(properties.get(PROP_DEFAULT_IS_SESSION), true);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.dynamicClassLoader);
        try {
            this.jspFactoryHandler = JspRuntimeContext.initFactoryHandler();
            this.tldLocationsCache = new SlingTldLocationsCache(componentContext.getBundleContext());
            this.ioProvider = new SlingIOProvider(this.classLoaderWriter);
            this.options = new JspServletOptions(this.slingServletContext, this.ioProvider, componentContext, this.tldLocationsCache);
            this.jspServletContext = new JspServletContext(this.ioProvider, this.slingServletContext, this.tldLocationsCache);
            this.servletConfig = new JspServletConfig(this.jspServletContext, properties);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event.topics", "org/apache/sling/api/resource/*");
        ((Dictionary)props).put("service.description", "JSP Script Modification Handler");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.eventHandlerRegistration = componentContext.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, props);
        this.logger.debug("IMPORTANT: Do not modify the generated servlets");
    }

    protected void deactivate(ComponentContext componentContext) {
        this.logger.debug("JspScriptEngine.deactivate()");
        if (this.tldLocationsCache != null) {
            this.tldLocationsCache.deactivate(componentContext.getBundleContext());
            this.tldLocationsCache = null;
        }
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
        if (this.jspRuntimeContext != null) {
            this.destroyJspRuntimeContext(this.jspRuntimeContext);
            this.jspRuntimeContext = null;
        }
        this.ioProvider = null;
        this.jspFactoryHandler.destroy();
        this.jspFactoryHandler = null;
    }

    protected void unbindSlingServletContext(ServletContext slingServletContext) {
        try {
            if (slingServletContext != null) {
                slingServletContext.removeAttribute(JspApplicationContextImpl.class.getName());
                slingServletContext.removeAttribute(AnnotationProcessor.class.getName());
            }
        }
        catch (NullPointerException npe) {
            this.logger.debug("unbindSlingServletContext: ServletContext might already be unavailable", (Throwable)npe);
        }
        if (this.slingServletContext == slingServletContext) {
            this.slingServletContext = null;
        }
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager rclp) {
        if (this.dynamicClassLoader != null) {
            this.ungetClassLoader();
        }
        this.getClassLoader(rclp);
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager rclp) {
        if (this.dynamicClassLoaderManager == rclp) {
            this.ungetClassLoader();
        }
    }

    private void getClassLoader(DynamicClassLoaderManager rclp) {
        this.dynamicClassLoaderManager = rclp;
        this.dynamicClassLoader = rclp.getDynamicClassLoader();
    }

    private void ungetClassLoader() {
        this.dynamicClassLoader = null;
        this.dynamicClassLoaderManager = null;
    }

    private void destroyJspRuntimeContext(JspRuntimeContext jrc) {
        if (jrc != null) {
            try {
                jrc.destroy();
            }
            catch (NullPointerException npe) {
                this.logger.debug("deactivate: ServletContext might already be unavailable", (Throwable)npe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JspRuntimeContext getJspRuntimeContext() {
        if (this.jspRuntimeContext == null) {
            JspScriptEngineFactory jspScriptEngineFactory = this;
            synchronized (jspScriptEngineFactory) {
                if (this.jspRuntimeContext == null) {
                    this.jspRuntimeContext = new JspRuntimeContext(this.slingServletContext, this.options, this.ioProvider);
                }
            }
        }
        return this.jspRuntimeContext;
    }

    public void handleEvent(Event event) {
        JspRuntimeContext rctxt;
        String path = (String)event.getProperty("path");
        if (path != null && (rctxt = this.jspRuntimeContext) != null && rctxt.handleModification(path)) {
            this.renewJspRuntimeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewJspRuntimeContext() {
        JspRuntimeContext jrc;
        JspScriptEngineFactory jspScriptEngineFactory = this;
        synchronized (jspScriptEngineFactory) {
            jrc = this.jspRuntimeContext;
            this.jspRuntimeContext = null;
        }
        Thread t = new Thread(){

            public void run() {
                JspScriptEngineFactory.this.destroyJspRuntimeContext(jrc);
            }
        };
        t.start();
    }

    protected void bindSlingServletContext(ServletContext servletContext) {
        this.slingServletContext = servletContext;
    }

    protected void bindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        this.classLoaderWriter = classLoaderWriter;
    }

    protected void unbindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        if (this.classLoaderWriter == classLoaderWriter) {
            this.classLoaderWriter = null;
        }
    }

    private static class BetterScriptException
    extends ScriptException {
        private static final long serialVersionUID = -6490165487977283019L;

        public BetterScriptException(String message, Exception cause) {
            super(message);
            this.initCause(cause);
        }
    }

    private class JspScriptEngine
    extends AbstractSlingScriptEngine {
        JspScriptEngine() {
            super((ScriptEngineFactory)((Object)JspScriptEngineFactory.this));
        }

        public Object eval(Reader script, ScriptContext context) throws ScriptException {
            Bindings props = context.getBindings(100);
            SlingScriptHelper scriptHelper = (SlingScriptHelper)props.get("sling");
            if (scriptHelper != null) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(JspScriptEngineFactory.this.dynamicClassLoader);
                try {
                    JspScriptEngineFactory.this.callJsp(props, scriptHelper, context);
                }
                catch (SlingServletException e) {
                    if (e.getCause() != null) {
                        Throwable rootCause = TagUtil.getRootCause((ServletException)e.getCause());
                        if (rootCause instanceof Exception) {
                            throw new BetterScriptException(rootCause.toString(), (Exception)rootCause);
                        }
                        throw new BetterScriptException(rootCause.toString(), new Exception("Wrapping Throwable: " + rootCause.toString(), rootCause));
                    }
                    throw new BetterScriptException(e.getMessage(), (Exception)((Object)e));
                }
                catch (SlingPageException sje) {
                    JspScriptEngineFactory.this.callErrorPageJsp(props, scriptHelper, context, sje.getErrorPage());
                }
                catch (Exception e) {
                    throw new BetterScriptException(e.getMessage(), e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            return null;
        }
    }
}

