/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JspServletConfig
implements ServletConfig {
    private final ServletContext servletContext;
    private String servletName;
    private Map<String, String> properties;

    JspServletConfig(ServletContext servletContext, Dictionary<?, ?> config) {
        this.servletContext = servletContext;
        this.servletName = (String)config.get("service.description");
        if (this.servletName == null) {
            this.servletName = "JSP Script Handler";
        }
        this.properties = new HashMap<String, String>();
        Enumeration<?> ke = config.keys();
        while (ke.hasMoreElements()) {
            String key = (String)ke.nextElement();
            if (!key.startsWith("jasper.")) continue;
            this.properties.put(key.substring("jasper.".length()), String.valueOf(config.get(key)));
        }
    }

    public String getInitParameter(String name) {
        return this.properties.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.properties.keySet());
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletName() {
        return this.servletName;
    }
}

