/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.Calendar;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.apache.sling.repoinit.parser.operations.PropertyLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SetProperties
extends Operation {
    private final List<String> paths;
    private final List<PropertyLine> lines;

    public SetProperties(List<String> paths, List<PropertyLine> lines) {
        this.paths = paths;
        this.lines = lines;
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitSetProperties(this);
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        for (PropertyLine line : this.lines) {
            sb.append("\n  ").append(line.toString());
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        try (Formatter formatter = new Formatter();){
            formatter.format("set properties on %s%n", SetProperties.pathsToString(this.paths));
            for (PropertyLine line : this.lines) {
                String type = line.getPropertyType() == null ? "" : "{" + line.getPropertyType().name() + "}";
                String values = SetProperties.valuesToString(line.getPropertyValues(), line.getPropertyType());
                if (line.isDefault()) {
                    formatter.format("default %s%s to %s%n", line.getPropertyName(), type, values);
                    continue;
                }
                formatter.format("set %s%s to %s%n", line.getPropertyName(), type, values);
            }
            formatter.format("end%n", new Object[0]);
            String string = formatter.toString();
            return string;
        }
    }

    @NotNull
    private static String valuesToString(@NotNull List<Object> values, @Nullable PropertyLine.PropertyType type) {
        List<String> strings = values.stream().map(o -> {
            if (type == null || type == PropertyLine.PropertyType.String) {
                return SetProperties.escapeQuotes(Objects.toString(o, ""));
            }
            if (type == PropertyLine.PropertyType.Date) {
                return "\"" + ISO8601.format((Calendar)o) + "\"";
            }
            return Objects.toString(o, null);
        }).collect(Collectors.toList());
        return SetProperties.listToString(strings);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public List<PropertyLine> getPropertyLines() {
        return this.lines;
    }
}

