/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.apiregions.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.sling.feature.apiregions.impl.RegionEnforcer;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

class ResolverHookImpl
implements ResolverHook {
    final Map<Map.Entry<String, Version>, List<String>> bsnVerMap;
    final Map<String, Set<String>> bundleFeatureMap;
    final Map<String, Set<String>> featureRegionMap;
    final Map<String, Set<String>> regionPackageMap;
    final Set<String> defaultRegions;

    ResolverHookImpl(Map<Map.Entry<String, Version>, List<String>> bsnVerMap, Map<String, Set<String>> bundleFeatureMap, Map<String, Set<String>> featureRegionMap, Map<String, Set<String>> regionPackageMap, Set<String> defaultRegions) {
        this.bsnVerMap = bsnVerMap;
        this.bundleFeatureMap = bundleFeatureMap;
        this.featureRegionMap = featureRegionMap;
        this.regionPackageMap = regionPackageMap;
        this.defaultRegions = defaultRegions;
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        if (!"osgi.wiring.package".equals(requirement.getNamespace())) {
            return;
        }
        Bundle reqBundle = requirement.getRevision().getBundle();
        long reqBundleID = reqBundle.getBundleId();
        String reqBundleName = reqBundle.getSymbolicName();
        Version reqBundleVersion = reqBundle.getVersion();
        HashSet<String> reqRegions = new HashSet<String>(this.defaultRegions);
        ArrayList<String> reqFeatures = new ArrayList<String>();
        List<String> aids = this.bsnVerMap.get(new AbstractMap.SimpleEntry<String, Version>(reqBundleName, reqBundleVersion));
        if (aids != null) {
            for (String aid : aids) {
                Set<String> fid = this.bundleFeatureMap.get(aid);
                if (fid == null) continue;
                reqFeatures.addAll(fid);
            }
            for (String feature : reqFeatures) {
                Set<String> fr = this.featureRegionMap.get(feature);
                if (fr == null) continue;
                reqRegions.addAll(fr);
            }
        }
        HashMap<BundleCapability, String> coveredCaps = new HashMap<BundleCapability, String>();
        HashMap<BundleCapability, String> bcFeatureMap = new HashMap<BundleCapability, String>();
        String packageName = null;
        block2: for (BundleCapability bc : candidates) {
            Version capBundleVersion;
            BundleRevision rev = bc.getRevision();
            Bundle capBundle = rev.getBundle();
            long capBundleID = capBundle.getBundleId();
            if (capBundleID == 0L) {
                coveredCaps.put(bc, null);
                continue;
            }
            if (capBundleID == reqBundleID) {
                coveredCaps.put(bc, null);
                continue;
            }
            String capBundleName = capBundle.getSymbolicName();
            List<String> capBundleArtifacts = this.bsnVerMap.get(new AbstractMap.SimpleEntry<String, Version>(capBundleName, capBundleVersion = capBundle.getVersion()));
            if (capBundleArtifacts == null) {
                coveredCaps.put(bc, "global");
                continue;
            }
            List<Object> capFeatures = new ArrayList();
            for (String string : capBundleArtifacts) {
                Set<String> capfeats = this.bundleFeatureMap.get(string);
                if (capfeats == null) continue;
                capFeatures.addAll(capfeats);
            }
            if (capFeatures.isEmpty()) {
                capFeatures = Collections.singletonList(null);
            }
            for (String string : capFeatures) {
                if (string == null) {
                    coveredCaps.put(bc, "global");
                    continue block2;
                }
                if (reqFeatures.contains(string)) {
                    coveredCaps.put(bc, null);
                    continue block2;
                }
                Set<String> capRegions = this.featureRegionMap.get(string);
                if (capRegions == null || capRegions.size() == 0) {
                    coveredCaps.put(bc, "global");
                    continue block2;
                }
                bcFeatureMap.put(bc, string);
                ArrayList<String> sharedRegions = new ArrayList<String>(reqRegions);
                sharedRegions.retainAll(capRegions);
                Object pkg = bc.getAttributes().get("osgi.wiring.package");
                if (!(pkg instanceof String)) continue;
                packageName = (String)pkg;
                for (String region : sharedRegions) {
                    Set<String> regionPackages = this.regionPackageMap.get(region);
                    if (regionPackages == null || !regionPackages.contains(packageName)) continue;
                    coveredCaps.put(bc, region);
                    continue block2;
                }
                Set<String> globalPackages = this.regionPackageMap.get("global");
                if (globalPackages == null || !globalPackages.contains(packageName)) continue;
                coveredCaps.put(bc, "global");
                continue block2;
            }
        }
        this.pruneCoveredCaps(reqRegions, coveredCaps);
        ArrayList<BundleCapability> removedCandidates = new ArrayList<BundleCapability>(candidates);
        candidates.retainAll(coveredCaps.keySet());
        if (candidates.isEmpty()) {
            removedCandidates.removeAll(candidates);
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (BundleCapability bc : removedCandidates) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                String capFeat = (String)bcFeatureMap.get(bc);
                sb.append(bc.toString());
                sb.append("[Regions: ");
                sb.append(this.getRegionsForPackage(packageName, capFeat));
                sb.append(", Feature: ");
                sb.append(capFeat);
                sb.append("]");
            }
            RegionEnforcer.LOG.log(Level.WARNING, "API-Regions removed candidates {0} for requirement {1} as the requirement is in the following regions: {2} and in feature: {3}", new Object[]{sb, requirement, reqRegions, reqFeatures});
        }
    }

    private void pruneCoveredCaps(Set<String> reqRegions, Map<BundleCapability, String> capMap) {
        HashSet<String> reqNonGlobalRegions = new HashSet<String>(reqRegions);
        reqNonGlobalRegions.remove("global");
        if (capMap.size() <= 1) {
            return;
        }
        if (reqRegions.size() == 0 || Collections.singleton("global").equals(reqRegions)) {
            return;
        }
        ArrayList<BundleCapability> specificCaps = new ArrayList<BundleCapability>();
        for (Map.Entry<BundleCapability, String> entry : capMap.entrySet()) {
            String capRegion = entry.getValue();
            if (capRegion == null) {
                specificCaps.add(entry.getKey());
                continue;
            }
            if (!reqNonGlobalRegions.contains(capRegion)) continue;
            specificCaps.add(entry.getKey());
        }
        if (specificCaps.size() == 0) {
            return;
        }
        Iterator<Map.Entry<BundleCapability, String>> it = capMap.keySet().iterator();
        while (it.hasNext()) {
            if (specificCaps.contains(it.next())) continue;
            it.remove();
        }
    }

    List<String> getRegionsForPackage(String packageName, String feature) {
        if (packageName == null) {
            return Collections.emptyList();
        }
        Set<String> regions = this.featureRegionMap.get(feature);
        if (regions == null) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        boolean found = false;
        for (String region : regions) {
            Set<String> packages = this.regionPackageMap.get(region);
            if (packages == null) continue;
            if (found) {
                res.add(region);
                continue;
            }
            if (!packages.contains(packageName)) continue;
            res.add(region);
            found = true;
        }
        return res;
    }

    public void end() {
    }
}

