/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.apiregions.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sling.feature.apiregions.impl.ResolverHookImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleRevision;

class RegionEnforcer
implements ResolverHookFactory {
    public static final String GLOBAL_REGION = "global";
    static final String CLASSLOADER_PSEUDO_PROTOCOL = "classloader://";
    static final String APIREGIONS_JOINGLOBAL = "sling.feature.apiregions.joinglobal";
    static final String DEFAULT_REGIONS = "sling.feature.apiregions.default";
    static final String PROPERTIES_RESOURCE_PREFIX = "sling.feature.apiregions.resource.";
    static final String PROPERTIES_FILE_LOCATION = "sling.feature.apiregions.location";
    static final String IDBSNVER_FILENAME = "idbsnver.properties";
    static final String BUNDLE_FEATURE_FILENAME = "bundles.properties";
    static final String FEATURE_REGION_FILENAME = "features.properties";
    static final String REGION_PACKAGE_FILENAME = "regions.properties";
    static final Logger LOG = Logger.getLogger(ResolverHookImpl.class.getName());
    final Map<Map.Entry<String, Version>, List<String>> bsnVerMap;
    final Map<String, Set<String>> bundleFeatureMap;
    final Map<String, Set<String>> featureRegionMap;
    final Map<String, Set<String>> regionPackageMap;
    final Set<String> defaultRegions;

    RegionEnforcer(BundleContext context, Dictionary<String, Object> regProps) throws IOException, URISyntaxException {
        String defRegProp;
        URI idbsnverFile = this.getDataFileURI(context, IDBSNVER_FILENAME);
        regProps.put(IDBSNVER_FILENAME, idbsnverFile.toString());
        Map<Map.Entry<String, Version>, List<String>> bvm = RegionEnforcer.populateBSNVerMap(idbsnverFile);
        URI bundlesFile = this.getDataFileURI(context, BUNDLE_FEATURE_FILENAME);
        regProps.put(BUNDLE_FEATURE_FILENAME, bundlesFile.toString());
        Map<String, Set<String>> bfm = RegionEnforcer.populateBundleFeatureMap(bundlesFile);
        URI featuresFile = this.getDataFileURI(context, FEATURE_REGION_FILENAME);
        regProps.put(FEATURE_REGION_FILENAME, featuresFile.toString());
        Map<String, Set<String>> frm = RegionEnforcer.populateFeatureRegionMap(featuresFile);
        URI regionsFile = this.getDataFileURI(context, REGION_PACKAGE_FILENAME);
        regProps.put(REGION_PACKAGE_FILENAME, regionsFile.toString());
        Map<String, Set<String>> rpm = RegionEnforcer.populateRegionPackageMap(regionsFile);
        String toglobal = context.getProperty(APIREGIONS_JOINGLOBAL);
        if (toglobal != null) {
            this.joinRegionsWithGlobal(toglobal, rpm);
            regProps.put(APIREGIONS_JOINGLOBAL, toglobal);
        }
        if ((defRegProp = context.getProperty(DEFAULT_REGIONS)) != null) {
            HashSet<String> defRegs = new HashSet<String>();
            for (String region : Arrays.asList(defRegProp.split(","))) {
                if (region.length() <= 0) continue;
                defRegs.add(region);
            }
            this.defaultRegions = Collections.unmodifiableSet(defRegs);
            if (this.defaultRegions.size() > 0) {
                regProps.put(DEFAULT_REGIONS, this.defaultRegions.toString());
            }
        } else {
            this.defaultRegions = Collections.emptySet();
        }
        this.bsnVerMap = RegionEnforcer.unmodifiableMapToList(bvm);
        this.bundleFeatureMap = RegionEnforcer.unmodifiableMapToSet(bfm);
        this.featureRegionMap = RegionEnforcer.unmodifiableMapToSet(frm);
        this.regionPackageMap = RegionEnforcer.unmodifiableMapToSet(rpm);
    }

    private static <K, V> Map<K, List<V>> unmodifiableMapToList(Map<K, List<V>> m) {
        for (Map.Entry<K, List<V>> entry : m.entrySet()) {
            m.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(m);
    }

    private static <K, V> Map<K, Set<V>> unmodifiableMapToSet(Map<K, Set<V>> m) {
        for (Map.Entry<K, Set<V>> entry : m.entrySet()) {
            m.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(m);
    }

    private void joinRegionsWithGlobal(String toglobal, Map<String, Set<String>> rpm) {
        for (String region : toglobal.split(",")) {
            Set<String> packages = rpm.get(region);
            if (packages == null) continue;
            RegionEnforcer.addValuesToMap(rpm, GLOBAL_REGION, packages);
            rpm.remove(region);
        }
    }

    private static Map<Map.Entry<String, Version>, List<String>> populateBSNVerMap(URI idbsnverFile) throws IOException {
        HashMap<Map.Entry<String, Version>, List<String>> m = new HashMap<Map.Entry<String, Version>, List<String>>();
        Properties p = new Properties();
        try (InputStream is = idbsnverFile.toURL().openStream();){
            p.load(is);
        }
        for (String n : p.stringPropertyNames()) {
            String[] bsnver = p.getProperty(n).split("~");
            RegionEnforcer.addBsnVerArtifact(m, bsnver[0], bsnver[1], n);
        }
        return m;
    }

    private static void addBsnVerArtifact(Map<Map.Entry<String, Version>, List<String>> bsnVerMap, String bundleSymbolicName, String bundleVersion, String artifactId) {
        Version version = Version.valueOf((String)bundleVersion);
        AbstractMap.SimpleEntry<String, Version> bsnVer = new AbstractMap.SimpleEntry<String, Version>(bundleSymbolicName, version);
        List<String> l = bsnVerMap.get(bsnVer);
        if (l == null) {
            l = new ArrayList<String>();
            bsnVerMap.put(bsnVer, l);
        }
        l.add(artifactId);
    }

    private static Map<String, Set<String>> populateBundleFeatureMap(URI bundlesFile) throws IOException {
        return RegionEnforcer.loadMap(bundlesFile);
    }

    private static Map<String, Set<String>> populateFeatureRegionMap(URI featuresFile) throws IOException {
        return RegionEnforcer.loadMap(featuresFile);
    }

    private static Map<String, Set<String>> populateRegionPackageMap(URI regionsFile) throws IOException {
        return RegionEnforcer.loadMap(regionsFile);
    }

    private static Map<String, Set<String>> loadMap(URI propsFile) throws IOException {
        HashMap<String, Set<String>> m = new HashMap<String, Set<String>>();
        Properties p = new Properties();
        try (InputStream is = propsFile.toURL().openStream();){
            p.load(is);
        }
        for (String n : p.stringPropertyNames()) {
            String[] features = p.getProperty(n).split(",");
            RegionEnforcer.addValuesToMap(m, n, features);
        }
        return m;
    }

    private static void addValuesToMap(Map<String, Set<String>> map, String key, String ... values) {
        RegionEnforcer.addValuesToMap(map, key, Arrays.asList(values));
    }

    private static void addValuesToMap(Map<String, Set<String>> map, String key, Collection<String> values) {
        Set<String> bf = map.get(key);
        if (bf == null) {
            bf = new LinkedHashSet<String>();
            map.put(key, bf);
        }
        bf.addAll(values);
    }

    private URI getDataFileURI(BundleContext ctx, String name) throws IOException, URISyntaxException {
        String loc;
        String fn = ctx.getProperty(PROPERTIES_RESOURCE_PREFIX + name);
        if (fn == null && (loc = ctx.getProperty(PROPERTIES_FILE_LOCATION)) != null) {
            fn = loc + "/" + name;
        }
        if (fn == null) {
            throw new IOException("API Region Enforcement enabled, but no configuration found to find region definition resource: " + name);
        }
        if (fn.contains(":")) {
            if (fn.startsWith(CLASSLOADER_PSEUDO_PROTOCOL)) {
                loc = fn.substring(CLASSLOADER_PSEUDO_PROTOCOL.length());
                if (!loc.startsWith("/")) {
                    loc = "/" + loc;
                }
                fn = this.getClass().getResource(loc).toString();
            }
            return new URI(fn);
        }
        return new File(fn).toURI();
    }

    public ResolverHook begin(Collection<BundleRevision> triggers) {
        return new ResolverHookImpl(this.bsnVerMap, this.bundleFeatureMap, this.featureRegionMap, this.regionPackageMap, this.defaultRegions);
    }
}

