/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.apiregions.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import org.apache.sling.feature.apiregions.impl.RegionEnforcer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class Activator
implements BundleActivator,
FrameworkListener {
    static final String MANAGED_SERVICE_PKG_NAME = "org.osgi.service.cm";
    static final String MANAGED_SERVICE_CLASS_NAME = "org.osgi.service.cm.ManagedService";
    static final String REGIONS_PROPERTY_NAME = "org.apache.sling.feature.apiregions.regions";
    BundleContext bundleContext;
    ServiceRegistration<ResolverHookFactory> hookRegistration;

    public synchronized void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.registerHook();
        context.addFrameworkListener((FrameworkListener)this);
    }

    public synchronized void stop(BundleContext context) throws Exception {
    }

    synchronized void registerHook() {
        if (this.hookRegistration != null) {
            return;
        }
        if (this.bundleContext.getProperty(REGIONS_PROPERTY_NAME) == null) {
            RegionEnforcer.LOG.log(Level.WARNING, "API Regions not enabled. To enable set framework property: org.apache.sling.feature.apiregions.regions");
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        try {
            RegionEnforcer enforcer = new RegionEnforcer(this.bundleContext, props);
            this.hookRegistration = this.bundleContext.registerService(ResolverHookFactory.class, (Object)enforcer, props);
        }
        catch (Exception e) {
            RegionEnforcer.LOG.log(Level.SEVERE, "Problem activating API Regions runtime enforcement component", e);
        }
    }

    synchronized void unregisterHook() {
        if (this.hookRegistration != null) {
            this.hookRegistration.unregister();
            this.hookRegistration = null;
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            this.bundleContext.removeFrameworkListener((FrameworkListener)this);
            FrameworkWiring fw = (FrameworkWiring)this.bundleContext.getBundle().adapt(FrameworkWiring.class);
            if (fw == null) {
                RegionEnforcer.LOG.log(Level.WARNING, "The API Regions runtime fragment is not attached to the system bundle.");
                return;
            }
            Requirement cmReq = Activator.createPackageRequirement();
            Collection providers = fw.findProviders(cmReq);
            for (BundleCapability cap : providers) {
                try {
                    ClassLoader loader = cap.getRevision().getWiring().getClassLoader();
                    final Class<?> msClass = loader.loadClass(MANAGED_SERVICE_CLASS_NAME);
                    Object ms = Proxy.newProxyInstance(loader, new Class[]{msClass}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Class<?> mdDecl = method.getDeclaringClass();
                            if (mdDecl.equals(Object.class)) {
                                switch (method.getName()) {
                                    case "equals": {
                                        return proxy == args[0];
                                    }
                                    case "hashCode": {
                                        return System.identityHashCode(proxy);
                                    }
                                    case "toString": {
                                        return "Proxy for " + msClass;
                                    }
                                }
                                throw new UnsupportedOperationException("Method " + method + " not supported on proxy for " + msClass);
                            }
                            if ("updated".equals(method.getName()) && args.length == 1) {
                                Object arg = args[0];
                                if (arg == null) {
                                    Activator.this.registerHook();
                                } else if (arg instanceof Dictionary) {
                                    Dictionary props = (Dictionary)args[0];
                                    Object disabled = props.get("disable");
                                    if ("true".equals(disabled)) {
                                        Activator.this.unregisterHook();
                                    } else {
                                        Activator.this.registerHook();
                                    }
                                }
                            }
                            return null;
                        }
                    });
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("service.pid", this.getClass().getPackage().getName());
                    this.bundleContext.registerService(MANAGED_SERVICE_CLASS_NAME, ms, props);
                    return;
                }
                catch (Exception e) {
                    RegionEnforcer.LOG.log(Level.WARNING, "Problem attempting to register ManagedService from " + cap, e);
                }
            }
            RegionEnforcer.LOG.log(Level.INFO, "No Configuration Admin API available");
        }
    }

    static Requirement createPackageRequirement() {
        Requirement cmReq = new Requirement(){

            public String getNamespace() {
                return "osgi.wiring.package";
            }

            public Map<String, String> getDirectives() {
                return Collections.singletonMap("filter", "(osgi.wiring.package=org.osgi.service.cm)");
            }

            public Map<String, Object> getAttributes() {
                return Collections.emptyMap();
            }

            public Resource getResource() {
                return null;
            }
        };
        return cmReq;
    }
}

